/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.singleton;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddSingletonSubsystem
implements WildFly10SubsystemMigrationTask {
    public static final AddSingletonSubsystem INSTANCE = new AddSingletonSubsystem();
    private static final String DEFAULT_ATTR_NAME = "default";
    private static final String DEFAULT_ATTR_VALUE = "default";
    private static final String SINGLETON_POLICY = "singleton-policy";
    private static final String CACHE_CONTAINER_ATTR_NAME = "cache-container";
    private static final String CACHE_CONTAINER_ATTR_VALUE = "server";
    private static final String ELECTION_POLICY = "election-policy";
    private static final String ELECTION_POLICY_NAME = "simple";

    private AddSingletonSubsystem() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config != null) {
            return;
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Adding subsystem %s...", (Object)subsystem.getName());
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress subsystemPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName())});
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        subsystemAddOperation.get("default").set("default");
        compositeOperationBuilder.addStep(subsystemAddOperation);
        PathAddress singletonPolicyPathAddress = subsystemPathAddress.append(SINGLETON_POLICY, "default");
        ModelNode singletonPolicyAddOperation = Util.createAddOperation((PathAddress)singletonPolicyPathAddress);
        singletonPolicyAddOperation.get(CACHE_CONTAINER_ATTR_NAME).set(CACHE_CONTAINER_ATTR_VALUE);
        compositeOperationBuilder.addStep(singletonPolicyAddOperation);
        PathAddress electionPolicyPathAddress = singletonPolicyPathAddress.append(ELECTION_POLICY, ELECTION_POLICY_NAME);
        ModelNode electionPolicyAddOperation = Util.createAddOperation((PathAddress)electionPolicyPathAddress);
        compositeOperationBuilder.addStep(electionPolicyAddOperation);
        server.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        ServerMigrationLogger.ROOT_LOGGER.infof("Subsystem %s added.", (Object)subsystem.getName());
    }
}

