/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.jberet;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddBatchJBeretSubsystem
implements WildFly10SubsystemMigrationTask {
    public static final AddBatchJBeretSubsystem INSTANCE = new AddBatchJBeretSubsystem();
    private static final String DEFAULT_JOB_REPOSITORY_ATTR_NAME = "default-job-repository";
    private static final String DEFAULT_JOB_REPOSITORY_ATTR_VALUE = "in-memory";
    private static final String DEFAULT_THREAD_POOL_ATTR_NAME = "default-thread-pool";
    private static final String DEFAULT_THREAD_POOL_ATTR_VALUE = "batch";
    private static final String IN_MEMORY_JOB_REPOSITORY = "in-memory-job-repository";
    private static final String THREAD_POOL = "thread-pool";
    private static final String MAX_THREADS = "max-threads";
    private static final String MAX_THREADS_VALUE = "10";
    private static final String KEEPALIVE_TIME = "keepalive-time";
    private static final String KEEPALIVE_TIME_TIME_ATTR_NAME = "time";
    private static final String KEEPALIVE_TIME_TIME_ATTR_VALUE = "30";
    private static final String KEEPALIVE_TIME_UNIT_ATTR_NAME = "unit";
    private static final String KEEPALIVE_TIME_UNIT_ATTR_VALUE = "seconds";

    private AddBatchJBeretSubsystem() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config != null) {
            return;
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Adding subsystem %s...", (Object)subsystem.getName());
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress subsystemPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName())});
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        subsystemAddOperation.get(DEFAULT_JOB_REPOSITORY_ATTR_NAME).set(DEFAULT_JOB_REPOSITORY_ATTR_VALUE);
        subsystemAddOperation.get(DEFAULT_THREAD_POOL_ATTR_NAME).set(DEFAULT_THREAD_POOL_ATTR_VALUE);
        compositeOperationBuilder.addStep(subsystemAddOperation);
        PathAddress jobReporsitoryPathAddress = subsystemPathAddress.append(IN_MEMORY_JOB_REPOSITORY, DEFAULT_JOB_REPOSITORY_ATTR_VALUE);
        ModelNode jobReporsitoryAddOperation = Util.createAddOperation((PathAddress)jobReporsitoryPathAddress);
        compositeOperationBuilder.addStep(jobReporsitoryAddOperation);
        PathAddress threadPoolPathAddress = subsystemPathAddress.append(THREAD_POOL, DEFAULT_THREAD_POOL_ATTR_VALUE);
        ModelNode threadPoolAddOperation = Util.createAddOperation((PathAddress)threadPoolPathAddress);
        threadPoolAddOperation.get(MAX_THREADS).set(MAX_THREADS_VALUE);
        ModelNode keepAliveTime = new ModelNode();
        keepAliveTime.get(KEEPALIVE_TIME_TIME_ATTR_NAME).set(KEEPALIVE_TIME_TIME_ATTR_VALUE);
        keepAliveTime.get(KEEPALIVE_TIME_UNIT_ATTR_NAME).set(KEEPALIVE_TIME_UNIT_ATTR_VALUE);
        threadPoolAddOperation.get(KEEPALIVE_TIME).set(keepAliveTime);
        compositeOperationBuilder.addStep(threadPoolAddOperation);
        server.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        ServerMigrationLogger.ROOT_LOGGER.infof("Subsystem %s added.", (Object)subsystem.getName());
    }
}

