/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.ejb3;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class DefinePassivationDisabledCacheRef
implements WildFly10SubsystemMigrationTask {
    public static final DefinePassivationDisabledCacheRef INSTANCE = new DefinePassivationDisabledCacheRef();
    private static final String DEFAULT_SFSB_CACHE_ATTR_NAME = "default-sfsb-cache";
    private static final String DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME = "default-sfsb-passivation-disabled-cache";

    private DefinePassivationDisabledCacheRef() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null || !config.hasDefined(DEFAULT_SFSB_CACHE_ATTR_NAME) || config.hasDefined(DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME)) {
            return;
        }
        String defaultSFSBCache = config.get(DEFAULT_SFSB_CACHE_ATTR_NAME).asString();
        ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName())}));
        op.get("name").set(DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME);
        op.get("value").set(defaultSFSBCache);
        server.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.infof("EJB3 subsystem's 'default-sfsb-passivation-disabled-cache' attribute set to %s.", (Object)defaultSFSBCache);
    }
}

