/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.wfly10.subsystem.MigrateLegacySubsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10Extension;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemBuilder;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class WildFly10ExtensionBuilder {
    private final List<WildFly10SubsystemBuilder> subsystems = new ArrayList<WildFly10SubsystemBuilder>();
    private String name;

    public WildFly10ExtensionBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public WildFly10ExtensionBuilder addSubsystem(WildFly10SubsystemBuilder subsystem) {
        this.subsystems.add(subsystem);
        return this;
    }

    public WildFly10ExtensionBuilder addSubsystem(String subsystemName, WildFly10SubsystemMigrationTask ... tasks) {
        WildFly10SubsystemBuilder subsystemBuilder = new WildFly10SubsystemBuilder().setName(subsystemName);
        if (tasks != null) {
            for (WildFly10SubsystemMigrationTask task : tasks) {
                subsystemBuilder.addTask(task);
            }
        }
        return this.addSubsystem(subsystemBuilder);
    }

    public WildFly10ExtensionBuilder addLegacySubsystem(String subsystemName) {
        return this.addSubsystem(new WildFly10SubsystemBuilder().setName(subsystemName).addTask(MigrateLegacySubsystem.INSTANCE));
    }

    public WildFly10Extension build() {
        WildFly10Extension extension = new WildFly10Extension(this.name);
        for (WildFly10SubsystemBuilder subsystem : this.subsystems) {
            extension.subsystems.add(subsystem.setExtension(extension).build());
        }
        return extension;
    }
}

