/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone.config;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;

public class WildFly10StandaloneConfigFileSecurityRealmsMigration<S extends Server> {
    public void run(ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        this.migrateSecurityRealms(source, target, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateSecurityRealms(ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating security realms...", new Object[0]);
        boolean targetStarted = target.isStarted();
        if (!targetStarted) {
            target.start();
        }
        try {
            for (ModelNode securityRealm : target.getSecurityRealms()) {
                this.migrateSecurityRealm(securityRealm, source, target, context);
            }
        }
        finally {
            if (!targetStarted) {
                target.stop();
            }
            ServerMigrationLogger.ROOT_LOGGER.info((Object)"Security realms migration done.");
        }
    }

    protected void migrateSecurityRealm(ModelNode securityRealm, ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        Property securityRealmProperty = securityRealm.asProperty();
        String securityRealmName = securityRealmProperty.getName();
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating security realm: %s", (Object)securityRealmName);
        ModelNode securityRealmValue = securityRealmProperty.getValue();
        if (securityRealmValue.hasDefined(new String[]{"authentication", "properties"})) {
            this.copyPropertiesFile(securityRealmValue.get(new String[]{"authentication", "properties"}), source, target, context);
        }
        if (securityRealmValue.hasDefined(new String[]{"authorization", "properties"})) {
            this.copyPropertiesFile(securityRealmValue.get(new String[]{"authorization", "properties"}), source, target, context);
        }
    }

    private void copyPropertiesFile(ModelNode properties, ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        if (properties.hasDefined("path")) {
            Path targetPath;
            String path = properties.get("path").asString();
            ServerMigrationLogger.ROOT_LOGGER.debugf("Properties path: %s", (Object)path);
            String relativeTo = null;
            if (properties.hasDefined("relative-to")) {
                relativeTo = properties.get("relative-to").asString();
            }
            ServerMigrationLogger.ROOT_LOGGER.debugf("Properties relative_to: %s", (Object)String.valueOf(relativeTo));
            if (relativeTo == null) {
                targetPath = Paths.get(path, new String[0]);
            } else {
                Path resolvedPath = target.resolvePath(relativeTo);
                if (resolvedPath == null) {
                    throw new IOException("failed to resolve path " + relativeTo);
                }
                targetPath = resolvedPath.normalize().resolve(path);
            }
            ServerMigrationLogger.ROOT_LOGGER.debugf("Properties file path target: %s", (Object)targetPath);
            Path targetServerBaseDir = target.getServer().getBaseDir();
            if (targetPath.startsWith(targetServerBaseDir)) {
                Path sourcePath = source.getServer().getBaseDir().resolve(targetServerBaseDir.relativize(targetPath));
                context.getMigrationFiles().copy(sourcePath, targetPath);
            }
        }
    }
}

