/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import java.util.stream.Stream;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.component.AfterTaskRun;
import org.jboss.migration.core.task.component.BeforeTaskRun;
import org.jboss.migration.core.task.component.CompositeTaskRunnable;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public interface SimpleComponentTaskBuilder<T extends SimpleComponentTaskBuilder<T>> {
    default public T name(String name) {
        return this.name(new ServerMigrationTaskName.Builder(name).build());
    }

    public T name(ServerMigrationTaskName var1);

    public T skipPolicy(TaskSkipPolicy var1);

    default public T skipPolicies(TaskSkipPolicy ... skipPolicies) {
        return this.skipPolicy(context -> {
            for (TaskSkipPolicy skipPolicy : skipPolicies) {
                if (!skipPolicy.isSkipped(context)) continue;
                return true;
            }
            return false;
        });
    }

    public T runnable(TaskRunnable var1);

    default public T runnables(TaskRunnable ... runnables) {
        return this.runnable(((CompositeTaskRunnable.Builder)new CompositeTaskRunnable.Builder().runnables(runnables)).build());
    }

    default public T subtask(SimpleComponentTaskBuilder<?> taskBuilder) {
        return this.runnable(context -> context.execute(taskBuilder.build()).getResult());
    }

    default public T subtasks(SimpleComponentTaskBuilder<?> ... taskBuilders) {
        return this.runnables((TaskRunnable[])Stream.of(taskBuilders).map(taskBuilder -> context -> context.execute(taskBuilder.build()).getResult()).toArray(TaskRunnable[]::new));
    }

    public T beforeRun(BeforeTaskRun var1);

    public T afterRun(AfterTaskRun var1);

    public ServerMigrationTask build();
}

