/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.jboss.migration.cli.CommandLineConstants;
import org.jboss.migration.cli.CommandLineOption;
import org.jboss.migration.cli.CommandLineOptions;
import org.jboss.migration.cli.CommandLineParser;
import org.jboss.migration.cli.commonscli.CommandLine;
import org.jboss.migration.cli.commonscli.HelpFormatter;
import org.jboss.migration.cli.commonscli.MissingOptionException;
import org.jboss.migration.cli.commonscli.ParseException;
import org.jboss.migration.cli.logger.CommandLineMigrationLogger;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.ServerMigration;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SystemEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.report.HtmlReportWriter;
import org.jboss.migration.core.report.XmlReportWriter;
import org.jboss.migration.core.task.ServerMigrationTaskResult;

public class CommandLineServerMigration {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final CommandLineOptions COMMAND_LINE_OPTIONS = CommandLineOptions.builder().nonDeprecatedOption(CommandLineOption.ENVIRONMENT).nonDeprecatedOption(CommandLineOption.HELP).nonDeprecatedOption(CommandLineOption.NON_INTERACTIVE).nonDeprecatedOption(CommandLineOption.SOURCE).nonDeprecatedOption(CommandLineOption.TARGET).deprecatedOption(CommandLineOption.INTERACTIVE).build();

    private CommandLineServerMigration() {
    }

    public static void main(String[] args) {
        try {
            String baseDir;
            boolean interactive;
            Path environment;
            CommandLine cmdLine = new CommandLineParser(false).parse(COMMAND_LINE_OPTIONS.getAllOptions(), args);
            if (cmdLine.hasOption(CommandLineConstants.HELP.getArgument())) {
                CommandLineServerMigration.help();
                return;
            }
            if (!cmdLine.hasOption(CommandLineConstants.SOURCE.getArgument())) {
                throw new MissingOptionException("Missing required option: " + CommandLineConstants.SOURCE.getArgument());
            }
            Path source = CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.SOURCE.getArgument()));
            if (!cmdLine.hasOption(CommandLineConstants.TARGET.getArgument())) {
                throw new MissingOptionException("Missing required option: " + CommandLineConstants.TARGET.getArgument());
            }
            Path target = CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.TARGET.getArgument()));
            Path path = environment = cmdLine.hasOption(CommandLineConstants.ENVIRONMENT.getArgument()) ? CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.ENVIRONMENT.getArgument())) : null;
            if (cmdLine.hasOption(CommandLineConstants.NON_INTERACTIVE.getArgument())) {
                interactive = false;
            } else {
                boolean bl = interactive = !cmdLine.hasOption(CommandLineConstants.INTERACTIVE.getArgument()) || Boolean.parseBoolean(cmdLine.getOptionValue(CommandLineConstants.INTERACTIVE.getArgument()));
            }
            if (!cmdLine.getArgList().isEmpty()) {
                System.err.printf("Incorrect argument(s), %s. Exiting...\n", cmdLine.getArgList());
                CommandLineServerMigration.help();
                System.exit(1);
            }
            if ((baseDir = SystemEnvironment.INSTANCE.getPropertyAsString("baseDir")) == null) {
                throw new RuntimeException("system environment does not specifies the tool's base dir");
            }
            Path baseDirPath = Paths.get(baseDir, new String[0]);
            Path configDirPath = baseDirPath.resolve("configuration");
            Path reportsDirPath = baseDirPath.resolve("reports");
            MigrationEnvironment userEnvironment = new MigrationEnvironment();
            Path configDirEnvironment = configDirPath.resolve("environment.properties");
            if (Files.exists(configDirEnvironment, new LinkOption[0])) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(configDirEnvironment));
            }
            if (environment != null) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(environment));
            }
            userEnvironment.setProperties((MigrationEnvironment)SystemEnvironment.INSTANCE);
            MigrationData migrationData = new ServerMigration().from(source).to(target).interactive(interactive).userEnvironment(userEnvironment).run();
            String htmlReportFileName = userEnvironment.getPropertyAsString("report.html.fileName");
            String xmlReportFileName = userEnvironment.getPropertyAsString("report.xml.fileName");
            if (htmlReportFileName != null) {
                try {
                    String htmlReportTemplateFileName = userEnvironment.getPropertyAsString("report.html.templateFileName", "migration-report-template.html");
                    Path htmlReportTemplatePath = configDirPath.resolve(htmlReportTemplateFileName);
                    HtmlReportWriter.INSTANCE.toPath(reportsDirPath.resolve(htmlReportFileName), migrationData, HtmlReportWriter.ReportTemplate.from((Path)htmlReportTemplatePath));
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"HTML Report write failed", e);
                }
            }
            if (xmlReportFileName != null) {
                try {
                    XmlReportWriter.INSTANCE.writeContent(reportsDirPath.resolve(xmlReportFileName).toFile(), migrationData);
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"XML Report write failed", e);
                }
            }
            if (migrationData.getRootTask().getResult().getStatus() == ServerMigrationTaskResult.Status.FAIL) {
                System.exit(1);
            }
        }
        catch (ParseException pex) {
            System.err.println(pex.getLocalizedMessage());
            CommandLineServerMigration.help();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace(STDERR);
            System.exit(1);
        }
    }

    private static void help() {
        System.out.println(CommandLineMigrationLogger.ROOT_LOGGER.helpHeader());
        HelpFormatter help = new HelpFormatter();
        help.setWidth(1024);
        help.printHelp(CommandLineMigrationLogger.ROOT_LOGGER.argUsage("jboss-server-migration"), COMMAND_LINE_OPTIONS.getNonDeprecatedOptions(), true);
    }

    private static Properties loadProperties(Path propertiesFilePath) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(propertiesFilePath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return properties;
    }

    private static Path resolvePath(String s) throws IllegalArgumentException {
        Path absolutePath;
        Path path = Paths.get(s, new String[0]).normalize();
        Path path2 = absolutePath = path.isAbsolute() ? path : Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path);
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + absolutePath + " does not exists.");
        }
        return absolutePath;
    }
}

