/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.servlet.AbsoluteOrderingMetaDataParser;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.TaglibMetaDataParser;
import org.jboss.metadata.parser.servlet.Version;
import org.jboss.metadata.parser.servlet.WebCommonMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.Web22MetaData;
import org.jboss.metadata.web.spec.Web23MetaData;
import org.jboss.metadata.web.spec.Web24MetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebMetaDataParser
extends MetaDataElementParser {
    public static WebMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        return WebMetaDataParser.parse(reader, info, false);
    }

    public static WebMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info, boolean validation) throws XMLStreamException {
        int i;
        int count;
        if (reader == null) {
            throw new IllegalArgumentException("Null reader");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        String schemaLocation = WebMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        Version version = null;
        if (info.getPublicID() != null) {
            version = Version.fromPublicID(info.getPublicID());
        }
        if (version == null && info.getSystemID() != null) {
            version = Version.fromSystemID(info.getSystemID());
        }
        if (version == null && schemaLocation != null) {
            version = Version.fromSystemID(schemaLocation);
        }
        if (version == null) {
            String versionString = null;
            count = reader.getAttributeCount();
            for (i = 0; i < count; ++i) {
                Attribute attribute;
                if (WebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("2.4".equals(versionString)) {
                version = Version.SERVLET_2_4;
            } else if ("2.5".equals(versionString)) {
                version = Version.SERVLET_2_5;
            } else if ("3.0".equals(versionString)) {
                version = Version.SERVLET_3_0;
            }
        }
        if (version == null) {
            throw new IllegalStateException("Cannot obtain servlet version");
        }
        WebMetaData wmd = null;
        switch (version) {
            case SERVLET_2_2: {
                wmd = new Web22MetaData();
                break;
            }
            case SERVLET_2_3: {
                wmd = new Web23MetaData();
                break;
            }
            case SERVLET_2_4: {
                wmd = new Web24MetaData();
                break;
            }
            case SERVLET_2_5: {
                wmd = new Web25MetaData();
                break;
            }
            case SERVLET_3_0: {
                wmd = new Web30MetaData();
            }
        }
        if (info != null) {
            wmd.setDTD(info.getBaseURI(), info.getPublicID(), info.getSystemID());
        }
        if (schemaLocation != null) {
            wmd.setSchemaLocation(schemaLocation);
        }
        count = reader.getAttributeCount();
        block19: for (i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (WebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    wmd.setId(value);
                    continue block19;
                }
                case VERSION: {
                    wmd.setVersion(value);
                    continue block19;
                }
                case METADATA_COMPLETE: {
                    if (wmd instanceof Web25MetaData || wmd instanceof Web30MetaData) {
                        if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block19;
                        if (wmd instanceof Web25MetaData) {
                            ((Web25MetaData)wmd).setMetadataComplete(true);
                        }
                        if (!(wmd instanceof Web30MetaData)) continue block19;
                        ((Web30MetaData)wmd).setMetadataComplete(true);
                        continue block19;
                    }
                    throw WebMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
                default: {
                    throw WebMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        block20: while (reader.hasNext() && reader.nextTag() != 2) {
            if (WebCommonMetaDataParser.parse(reader, wmd)) continue;
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env)) {
                if (wmd.getJndiEnvironmentRefsGroup() != null) continue;
                wmd.setJndiEnvironmentRefsGroup(env);
                continue;
            }
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (wmd.getDescriptionGroup() != null) continue;
                wmd.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ABSOLUTE_ORDERING: {
                    if (wmd instanceof Web30MetaData) {
                        ((Web30MetaData)wmd).setAbsoluteOrdering(AbsoluteOrderingMetaDataParser.parse(reader));
                        continue block20;
                    }
                    throw WebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case MODULE_NAME: {
                    if (wmd instanceof Web30MetaData) {
                        ((Web30MetaData)wmd).setModuleName(WebMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block20;
                    }
                    throw WebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case TAGLIB: {
                    if (wmd instanceof Web22MetaData || wmd instanceof Web23MetaData) {
                        List<TaglibMetaData> taglibs;
                        JspConfigMetaData jspConfig = wmd.getJspConfig();
                        if (jspConfig == null) {
                            jspConfig = new JspConfigMetaData();
                            wmd.setJspConfig(jspConfig);
                        }
                        if ((taglibs = jspConfig.getTaglibs()) == null) {
                            taglibs = new ArrayList<TaglibMetaData>();
                            jspConfig.setTaglibs(taglibs);
                        }
                        taglibs.add(TaglibMetaDataParser.parse(reader));
                        continue block20;
                    }
                    throw WebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw WebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return wmd;
    }
}

