/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.AnnotationMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;

public class ServletSecurityProcessor
extends AbstractFinderUser
implements Processor<AnnotationsMetaData, Class<?>>,
Creator<Class<?>, ServletSecurityMetaData> {
    public ServletSecurityProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(AnnotationsMetaData metaData, Class<?> type) {
        ServletSecurity annotation = (ServletSecurity)this.finder.getAnnotation(type, ServletSecurity.class);
        if (annotation == null) {
            return;
        }
        ServletSecurityMetaData servletSecurity = this.create(type);
        AnnotationMetaData annotationMD = (AnnotationMetaData)metaData.get(type.getName());
        if (annotationMD == null) {
            annotationMD = new AnnotationMetaData();
            annotationMD.setClassName(type.getName());
            metaData.add((MappableMetaData)annotationMD);
        }
        annotationMD.setServletSecurity(servletSecurity);
    }

    public ServletSecurityMetaData create(Class<?> element) {
        ServletSecurity servletSecurity = (ServletSecurity)this.finder.getAnnotation(element, ServletSecurity.class);
        if (servletSecurity == null) {
            return null;
        }
        ServletSecurityMetaData metaData = new ServletSecurityMetaData();
        HttpConstraint httpConstraint = servletSecurity.value();
        HttpMethodConstraint[] httpMethodConstraints = servletSecurity.httpMethodConstraints();
        metaData.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf(httpConstraint.value().toString()));
        metaData.setTransportGuarantee(TransportGuaranteeType.valueOf(httpConstraint.transportGuarantee().toString()));
        ArrayList<String> rolesAllowed = new ArrayList<String>();
        for (String role : httpConstraint.rolesAllowed()) {
            rolesAllowed.add(role);
        }
        metaData.setRolesAllowed(rolesAllowed);
        if (httpMethodConstraints != null && httpMethodConstraints.length > 0) {
            ArrayList<HttpMethodConstraintMetaData> methodConstraints = new ArrayList<HttpMethodConstraintMetaData>();
            for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraints) {
                HttpMethodConstraintMetaData methodConstraint = new HttpMethodConstraintMetaData();
                methodConstraint.setMethod(httpMethodConstraint.value());
                methodConstraint.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf(httpMethodConstraint.emptyRoleSemantic().toString()));
                methodConstraint.setTransportGuarantee(TransportGuaranteeType.valueOf(httpMethodConstraint.transportGuarantee().toString()));
                rolesAllowed = new ArrayList();
                for (String role : httpMethodConstraint.rolesAllowed()) {
                    rolesAllowed.add(role);
                }
                methodConstraint.setRolesAllowed(rolesAllowed);
                methodConstraints.add(methodConstraint);
            }
            metaData.setHttpMethodConstraints(methodConstraints);
        }
        return metaData;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(ServletSecurity.class);
    }
}

