/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.RelationRoleMetaDataParser;
import org.jboss.metadata.ejb.spec.RelationMetaData;
import org.jboss.metadata.ejb.spec.RelationRoleMetaData;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;

public class RelationMetaDataParser
extends AbstractMetaDataParser<RelationMetaData> {
    public static final RelationMetaDataParser INSTANCE = new RelationMetaDataParser();

    @Override
    public RelationMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        RelationMetaData data = new RelationMetaData();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (RelationMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.ID) continue;
            data.setId(reader.getAttributeValue(i));
        }
        this.processElements(data, reader);
        return data;
    }

    @Override
    protected void processElement(RelationMetaData relation, XMLStreamReader reader) throws XMLStreamException {
        DescriptionsImpl descriptionGroup = new DescriptionsImpl();
        if (DescriptionsMetaDataParser.parse((XMLStreamReader)reader, (DescriptionsImpl)descriptionGroup)) {
            if (relation.getDescriptions() == null) {
                relation.setDescriptions((Descriptions)descriptionGroup);
            }
            return;
        }
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_RELATION_NAME: {
                relation.setEjbRelationName(RelationMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case EJB_RELATIONSHIP_ROLE: {
                RelationRoleMetaData role = RelationRoleMetaDataParser.INSTANCE.parse(reader);
                List<RelationRoleMetaData> roles = relation.getEjbRelationshipRoles();
                roles.add(role);
                return;
            }
        }
        throw RelationMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }
}

