/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.NamedMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.ScheduleMetaDataParser;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.ScheduleMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.Accessor;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;

public class TimerMetaDataParser
extends AbstractMetaDataParser<TimerMetaData> {
    public static final TimerMetaDataParser INSTANCE = new TimerMetaDataParser();

    @Override
    public TimerMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        TimerMetaData timerMetaData = new TimerMetaData();
        this.processElements(timerMetaData, reader, propertyReplacer);
        return timerMetaData;
    }

    @Override
    protected void processElement(final TimerMetaData timer, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Accessor<DescriptionGroupMetaData> accessor = new Accessor<DescriptionGroupMetaData>(){

            public DescriptionGroupMetaData get() {
                DescriptionGroupMetaData descriptionGroupMetaData = timer.getDescriptionGroup();
                if (descriptionGroupMetaData == null) {
                    descriptionGroupMetaData = new DescriptionGroupMetaData();
                    timer.setDescriptionGroup(descriptionGroupMetaData);
                }
                return descriptionGroupMetaData;
            }
        };
        if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (Accessor)accessor)) {
            return;
        }
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case TIMEZONE: {
                String timezone = TimerMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                timer.setTimezone(timezone);
                return;
            }
            case INFO: {
                String info = TimerMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                timer.setInfo(info);
                return;
            }
            case PERSISTENT: {
                String persistent = TimerMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                if (persistent == null || persistent.trim().isEmpty()) {
                    throw TimerMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null or empty value for <persistent> element"));
                }
                timer.setPersistent(Boolean.parseBoolean(persistent));
                return;
            }
            case TIMEOUT_METHOD: {
                NamedMethodMetaData timeoutMethod = NamedMethodMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                timer.setTimeoutMethod(timeoutMethod);
                return;
            }
            case START: {
                String start = TimerMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                timer.setStart(TimerMetaDataParser.parseDateTime(start));
                return;
            }
            case END: {
                String end = TimerMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                timer.setEnd(TimerMetaDataParser.parseDateTime(end));
                return;
            }
            case SCHEDULE: {
                ScheduleMetaData schedule = ScheduleMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                timer.setSchedule(schedule);
                return;
            }
        }
        throw TimerMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }

    private static Calendar parseDateTime(String dateTime) {
        ClassLoader o = TimerMetaDataParser.getTccl();
        try {
            TimerMetaDataParser.setTccl(TimerMetaDataParser.class.getClassLoader());
            Calendar calendar = DatatypeConverter.parseDateTime((String)dateTime);
            return calendar;
        }
        finally {
            TimerMetaDataParser.setTccl(o);
        }
    }

    private static ClassLoader getTccl() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setTccl(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }
}

