/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceProperty;
import org.jboss.metadata.annotation.creator.AbstractInjectionTargetProcessor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceContextProcessor<E extends AnnotatedElement>
extends AbstractInjectionTargetProcessor<E> {
    public AbstractPersistenceContextProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(PersistenceContextReferencesMetaData refs, E element) {
        PersistenceContext annotation = this.finder.getAnnotation(element, PersistenceContext.class);
        if (annotation == null) {
            return;
        }
        this.process(refs, element, annotation);
    }

    protected void process(PersistenceContextReferencesMetaData refs, E element, PersistenceContext annotation) {
        PersistenceContextReferenceMetaData ref = this.createPC(element, annotation);
        this.addReference(refs, ref);
    }

    protected PersistenceContextReferenceMetaData createPC(E element, PersistenceContext annotation) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        PersistenceContextReferenceMetaData ref = new PersistenceContextReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = ProcessorUtils.getName(element);
        }
        ref.setPersistenceContextRefName(name);
        if (annotation.unitName().length() > 0) {
            ref.setPersistenceUnitName(annotation.unitName());
        }
        PersistenceContextType type = annotation.type();
        ref.setPersistenceContextType(type);
        PersistenceProperty[] properties = annotation.properties();
        if (properties.length > 0) {
            PropertiesMetaData refProperties = new PropertiesMetaData();
            for (PersistenceProperty p : properties) {
                PropertyMetaData pmd = new PropertyMetaData();
                pmd.setName(p.name());
                pmd.setValue(p.value());
                refProperties.add(pmd);
            }
            ref.setProperties(refProperties);
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = ProcessorUtils.getName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(PersistenceContext.class);
    }
}

