/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.spi.Connection;
import org.jboss.messaging.core.remoting.spi.ConnectionLifeCycleListener;
import org.jboss.messaging.core.remoting.spi.MessagingBuffer;
import org.jboss.messaging.integration.transports.netty.ChannelBufferWrapper;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyConnection
implements Connection {
    private static final Logger log = Logger.getLogger(NettyConnection.class);
    private final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;

    public NettyConnection(Channel channel, ConnectionLifeCycleListener listener) {
        this.channel = channel;
        this.listener = listener;
        listener.connectionCreated((Connection)this);
    }

    public synchronized void close() {
        ChannelFuture closeFuture;
        if (this.closed) {
            return;
        }
        SslHandler sslHandler = (SslHandler)this.channel.getPipeline().get("ssl");
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close(this.channel);
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    log.warn((Object)"Timed out waiting for ssl close future to complete");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = this.channel.close()).awaitUninterruptibly(10000L)) {
            log.warn((Object)"Timed out waiting for channel to close");
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    public MessagingBuffer createBuffer(int size) {
        return new ChannelBufferWrapper(ChannelBuffers.buffer((int)size));
    }

    public Object getID() {
        return this.channel.getId();
    }

    public void write(MessagingBuffer buffer) {
        this.write(buffer, false);
    }

    public void write(MessagingBuffer buffer, boolean flush) {
        ChannelFuture future = this.channel.write(buffer.getUnderlyingBuffer());
        if (flush) {
            while (true) {
                try {
                    boolean ok = future.await(10000L);
                    if (ok) break;
                    log.warn((Object)"Timed out waiting for packet to be flushed");
                }
                catch (InterruptedException ignore) {
                    continue;
                }
                break;
            }
        }
    }

    public String getRemoteAddress() {
        return this.channel.getRemoteAddress().toString();
    }

    public void fail(MessagingException me) {
        this.listener.connectionException((Object)this.channel.getId(), me);
    }
}

