/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.messaging.core.remoting.spi.BufferHandler;
import org.jboss.messaging.integration.transports.netty.MessagingFrameDecoder;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.ssl.SslHandler;

public class ChannelPipelineSupport {
    private ChannelPipelineSupport() {
    }

    public static void addCodecFilter(ChannelPipeline pipeline, BufferHandler handler) {
        assert (pipeline != null);
        pipeline.addLast("decoder", (ChannelHandler)new MessagingFrameDecoder(handler));
    }

    public static void addSSLFilter(ChannelPipeline pipeline, SSLContext context, boolean client) throws Exception {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        if (client) {
            engine.setWantClientAuth(true);
        }
        SslHandler handler = new SslHandler(engine);
        pipeline.addLast("ssl", (ChannelHandler)handler);
    }
}

