/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.AnnotationScanner;
import org.jboss.mcann.AnnotationScannerFactory;
import org.jboss.mcann.indexer.FileUtil;
import org.jboss.mcann.indexer.HTMLWriter;
import org.jboss.mcann.indexer.Main;

public class IndexerTask
extends Task {
    private File input = null;
    private File output = null;
    private boolean update = true;
    private File metadata = null;
    private boolean excludeAll = false;
    private String exclude = null;
    private File report = null;

    public File getInput() {
        return this.input;
    }

    public void setInput(File f) {
        this.input = f;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File f) {
        this.output = f;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean b) {
        this.update = b;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public void setMetadata(File f) {
        this.metadata = f;
    }

    public String getExclude() {
        return this.exclude;
    }

    public boolean isExcludeAll() {
        return this.excludeAll;
    }

    public void setExcludeAll(boolean b) {
        this.excludeAll = b;
    }

    public void setExclude(String s) {
        this.exclude = s;
    }

    public File getReport() {
        return this.report;
    }

    public void setReport(File r) {
        this.report = r;
    }

    public void execute() throws BuildException {
        try {
            if (this.output == null) {
                this.output = this.input;
            }
            Main m = new Main();
            AnnotationScanner as = AnnotationScannerFactory.getStrategy((int)0);
            URL[] urls = new URL[]{this.input.toURI().toURL()};
            URLClassLoader ucl = new URLClassLoader(urls);
            AnnotationRepository ari = as.scan((ClassLoader)ucl, urls);
            if (!this.excludeAll && this.exclude != null) {
                StringTokenizer st = new StringTokenizer(this.exclude, ",");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (!(s = s.trim()).endsWith(".class")) continue;
                    s = s.substring(0, s.indexOf(".class"));
                }
            }
            if (this.report != null) {
                if (!this.report.exists()) {
                    if (!this.report.mkdirs()) {
                        throw new IOException("Couldn't create directory: " + this.report);
                    }
                } else if (!this.report.isDirectory()) {
                    throw new IOException(this.report + " is not a directory");
                }
                HTMLWriter.generateCSS(this.report);
            }
            if (this.update) {
                File tmp = new File(System.getProperty("java.io.tmpdir"));
                File root = FileUtil.extract(this.input, tmp);
                File destination = new File(root, "META-INF");
                m.store(ari, destination);
                FileUtil.compress(root, this.output);
                FileUtil.recursiveDelete(root);
            } else {
                if (this.metadata.exists()) {
                    if (this.metadata.isFile()) {
                        throw new IOException("Metadata should be a directory: " + this.metadata);
                    }
                } else if (!this.metadata.mkdirs()) {
                    throw new IOException("Unable to create directory: " + this.metadata);
                }
                m.store(ari, this.metadata);
            }
        }
        catch (Throwable t) {
            throw new BuildException(t.getMessage(), t);
        }
    }
}

