/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import org.jboss.marshalling.reflect.ConcurrentReferenceHashMap;
import org.jboss.marshalling.reflect.SerializableClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializableClassRegistry {
    private static final SerializableClassRegistry INSTANCE = new SerializableClassRegistry();
    private static final SerializablePermission PERMISSION = new SerializablePermission("allowSerializationReflection");
    private final ConcurrentReferenceHashMap<Class<?>, SerializableClass> cache = new ConcurrentReferenceHashMap(512, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));

    private SerializableClassRegistry() {
    }

    public static SerializableClassRegistry getInstance() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(PERMISSION);
        }
        return INSTANCE;
    }

    public SerializableClass lookup(final Class<?> subject) {
        SerializableClass info = this.cache.get(subject);
        if (info != null) {
            return info;
        }
        info = AccessController.doPrivileged(new PrivilegedAction<SerializableClass>(){

            @Override
            public SerializableClass run() {
                return new SerializableClass(subject);
            }
        });
        SerializableClass old = this.cache.putIfAbsent(subject, info);
        return old != null ? old : info;
    }
}

