/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraceInformation
extends Throwable {
    private static final long serialVersionUID = 9017837359853233891L;
    Info info = null;

    TraceInformation() {
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("an exception which occurred:");
        Info info = this.info;
        if (info != null) {
            info.toString(builder);
        }
        return builder.toString();
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
    }

    private static TraceInformation getOrAddTraceInformation(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t is null");
        }
        while (!(t instanceof TraceInformation)) {
            Throwable c = t.getCause();
            if (c == null) {
                c = new TraceInformation();
                t.initCause(c);
            }
            t = c;
        }
        return (TraceInformation)t;
    }

    private static String getNiceClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return "(array of " + TraceInformation.getNiceClassName(clazz.getComponentType()) + ")";
        }
        if (clazz.isEnum() && clazz.getSuperclass() != Enum.class) {
            return TraceInformation.getNiceClassName(clazz.getSuperclass());
        }
        return clazz.getName();
    }

    public static void addUserInformation(Throwable t, Serializable data) {
        TraceInformation ti = TraceInformation.getOrAddTraceInformation(t);
        Info oldInfo = ti.info;
        ti.info = new UserInfo(oldInfo, data);
    }

    public static void addFieldInformation(Throwable t, String fieldName) {
        TraceInformation ti = TraceInformation.getOrAddTraceInformation(t);
        Info oldInfo = ti.info;
        ti.info = new FieldInfo(oldInfo, fieldName);
    }

    public static void addObjectInformation(Throwable t, Object targetObject) {
        TraceInformation ti = TraceInformation.getOrAddTraceInformation(t);
        String targetClassName = TraceInformation.getNiceClassName(targetObject.getClass());
        int targetHashCode = targetObject.hashCode();
        Info oldInfo = ti.info;
        ti.info = new ObjectInfo(oldInfo, targetClassName, targetHashCode);
    }

    public static void addIncompleteObjectInformation(Throwable t, Class<?> targetClass) {
        TraceInformation.addIncompleteObjectInformation(t, TraceInformation.getNiceClassName(targetClass));
    }

    public static void addIncompleteObjectInformation(Throwable t, String targetClassName) {
        TraceInformation ti = TraceInformation.getOrAddTraceInformation(t);
        Info oldInfo = ti.info;
        ti.info = new IncompleteObjectInfo(oldInfo, targetClassName);
    }

    public static void addIndexInformation(Throwable t, int index, int size, IndexType kind) {
        TraceInformation ti = TraceInformation.getOrAddTraceInformation(t);
        Info oldInfo = ti.info;
        ti.info = new IndexInfo(oldInfo, index, size, kind);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        MAP_KEY,
        MAP_VALUE,
        ELEMENT;

    }

    public static final class UserInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = 5504303963528386454L;
        private final Serializable data;

        UserInfo(Info cause, Serializable data) {
            super(cause);
            this.data = data;
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\t\t-> ").append(this.data);
        }
    }

    public static final class IndexInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = -5402179533085530855L;
        private final int idx;
        private final int size;
        private final IndexType kind;

        IndexInfo(Info cause, int idx, int size, IndexType kind) {
            super(cause);
            this.idx = idx;
            this.size = size;
            this.kind = kind;
            if (kind == null) {
                throw new NullPointerException("kind is null");
            }
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\tin ");
            switch (this.kind) {
                case MAP_KEY: {
                    builder.append("map key");
                    break;
                }
                case MAP_VALUE: {
                    builder.append("map value");
                    break;
                }
                default: {
                    builder.append("element");
                }
            }
            builder.append(" at index [").append(this.idx).append(']');
            if (this.size >= 0) {
                builder.append(" of size [");
                if (this.size == Integer.MAX_VALUE) {
                    builder.append("MAX_VALUE");
                } else {
                    builder.append(this.size);
                }
                builder.append(']');
            }
        }
    }

    public static final class FieldInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = -7502908990208699055L;
        private final String fieldName;

        FieldInfo(Info cause, String fieldName) {
            super(cause);
            this.fieldName = fieldName;
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\tin field ").append(this.fieldName);
        }
    }

    public static final class IncompleteObjectInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = -8580895864558204394L;
        private final String targetClassName;

        public IncompleteObjectInfo(Info cause, String targetClassName) {
            super(cause);
            this.targetClassName = targetClassName;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\tin object of type ").append(this.targetClassName);
        }
    }

    public static final class ClassInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = -8580895864558204394L;
        private final String targetClassName;

        ClassInfo(Info cause, String targetClassName) {
            super(cause);
            this.targetClassName = targetClassName;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\tin class ").append(this.targetClassName);
        }
    }

    public static final class ObjectInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = -8580895864558204394L;
        private final String targetClassName;
        private final int targetHashCode;

        ObjectInfo(Info cause, String targetClassName, int targetHashCode) {
            super(cause);
            this.targetClassName = targetClassName;
            this.targetHashCode = targetHashCode;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        public int getTargetHashCode() {
            return this.targetHashCode;
        }

        protected void toString(StringBuilder builder) {
            super.toString(builder);
            builder.append("\n\tin object ").append(this.targetClassName).append('@').append(Integer.toHexString(this.targetHashCode));
        }
    }

    public static final class MethodInfo
    extends Info
    implements Serializable {
        private static final long serialVersionUID = 646518183715279704L;

        MethodInfo(Info cause) {
            super(cause);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            READ_OBJECT,
            READ_OBJECT_NO_DATA,
            WRITE_OBJECT,
            EXTERNALIZABLE_READ_OBJECT,
            EXTERNALIZABLE_WRITE_OBJECT,
            EXTERNALIZER_READ_OBJECT,
            EXTERNALIZER_WRITE_OBJECT,
            EXTERNALIZER_CREATE_OBJECT;

        }
    }

    public static abstract class Info
    implements Serializable {
        private static final long serialVersionUID = -5600603940887712730L;
        private final Info cause;

        Info(Info cause) {
            this.cause = cause;
        }

        public Info getCause() {
            return this.cause;
        }

        protected void toString(StringBuilder builder) {
            Info cause = this.getCause();
            if (cause != null) {
                cause.toString(builder);
            }
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder(256);
            this.toString(builder);
            return builder.toString();
        }
    }
}

