/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.AbstractClassResolver;

public class ContextClassResolver
extends AbstractClassResolver {
    private static final PrivilegedAction<ClassLoader> classLoaderAction = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public ContextClassResolver() {
    }

    public ContextClassResolver(boolean enforceSerialVersionUid) {
        super(enforceSerialVersionUid);
    }

    protected ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(classLoaderAction);
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

