/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import org.jboss.marshalling.Creator;

public class PublicReflectiveCreator
implements Creator {
    @Override
    public <T> T create(Class<T> clazz) throws InvalidClassException {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            InvalidClassException ice = new InvalidClassException(clazz.getName(), "Constructor threw an exception");
            ice.initCause(e);
            throw ice;
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(clazz.getName(), "Illegal access exception occurred accessing the constructor: " + String.valueOf(e));
        }
        catch (InstantiationException e) {
            throw new InvalidClassException(clazz.getName(), "Instantiation exception: " + String.valueOf(e));
        }
        catch (NoSuchMethodException e) {
            throw new InvalidClassException(clazz.getName(), "No public, zero-arg constructor");
        }
    }
}

