/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.bean.metadata.jbmeta;

import java.util.List;

import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.managed.bean.metadata.MethodMetadata;

/**
 * InterceptorBinding
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class InterceptorBindingMetaData
{

   private boolean excludeClassInterceptors;
   
   private boolean excludeDefaultInterceptors;

   private List<InterceptorMetadata<?>> interceptors;

   private MethodMetadata method;
   
   public InterceptorBindingMetaData(List<InterceptorMetadata<?>> interceptors)
   {
      this(interceptors, null);
   }
   
   public InterceptorBindingMetaData(List<InterceptorMetadata<?>> interceptors, MethodMetadata method)
   {
      if (interceptors == null)
      {
         throw new IllegalArgumentException("interceptors cannot be null");
      }
      this.interceptors = interceptors;
      this.method = method;
   }
   
   public List<InterceptorMetadata<?>> getInterceptors()
   {
      return this.interceptors;
   }
   
   public void addInterceptor(InterceptorMetadata<?> interceptor)
   {
      this.interceptors.add(interceptor);
   }
   
   public boolean isExcludeClassInterceptors()
   {
      return excludeClassInterceptors;
   }

   public void setExcludeClassInterceptors(boolean excludeClassInterceptors)
   {
      this.excludeClassInterceptors = excludeClassInterceptors;
   }

   public boolean isExcludeDefaultInterceptors()
   {
      return excludeDefaultInterceptors;
   }

   public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors)
   {
      this.excludeDefaultInterceptors = excludeDefaultInterceptors;
   }

   public MethodMetadata getMethod()
   {
      return method;
   }

   public void setMethod(MethodMetadata method)
   {
      this.method = method;
   }

   public boolean isClassLevelBinding()
   {
      return this.method == null;
   }
   
}
