/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class AsyncHandler
extends ExtHandler {
    private final BlockingQueue<ExtLogRecord> recordQueue;
    private final int queueLength;
    private final Thread thread;
    private volatile OverflowAction overflowAction = OverflowAction.BLOCK;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<AsyncHandler> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(AsyncHandler.class, "state");
    private static final int DEFAULT_QUEUE_LENGTH = 512;

    public AsyncHandler(int queueLength, ThreadFactory threadFactory) {
        this.recordQueue = new ArrayBlockingQueue<ExtLogRecord>(queueLength);
        this.thread = threadFactory.newThread(new AsyncTask());
        if (this.thread == null) {
            throw new IllegalArgumentException("Thread factory did not create a thread");
        }
        this.thread.setDaemon(true);
        this.queueLength = queueLength;
    }

    public AsyncHandler(ThreadFactory threadFactory) {
        this(512, threadFactory);
    }

    public AsyncHandler(int queueLength) {
        this(queueLength, Executors.defaultThreadFactory());
    }

    public AsyncHandler() {
        this(512);
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public OverflowAction getOverflowAction() {
        return this.overflowAction;
    }

    public void setOverflowAction(OverflowAction overflowAction) {
        if (overflowAction == null) {
            throw new NullPointerException("overflowAction is null");
        }
        AsyncHandler.checkAccess();
        this.overflowAction = overflowAction;
    }

    @Override
    protected void doPublish(ExtLogRecord record) {
        switch (this.state) {
            case 0: {
                if (stateUpdater.compareAndSet(this, 0, 1)) {
                    this.thread.start();
                }
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        BlockingQueue<ExtLogRecord> recordQueue = this.recordQueue;
        if (this.isCallerCalculationRequired()) {
            record.copyAll();
        } else {
            record.disableCallerCalculation();
            record.copyMdc();
        }
        if (this.overflowAction == OverflowAction.DISCARD) {
            recordQueue.offer(record);
        } else {
            try {
                recordQueue.put(record);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        AsyncHandler.checkAccess();
        if (stateUpdater.getAndSet(this, 2) != 2) {
            this.thread.interrupt();
            super.close();
        }
    }

    public static enum OverflowAction {
        BLOCK,
        DISCARD;

    }

    private final class AsyncTask
    implements Runnable {
        private AsyncTask() {
        }

        @Override
        public void run() {
            BlockingQueue<ExtLogRecord> recordQueue = AsyncHandler.this.recordQueue;
            Handler[] handlers = AsyncHandler.this.handlers;
            boolean intr = false;
            try {
                while (true) {
                    ExtLogRecord rec;
                    block13: {
                        rec = null;
                        try {
                            if (AsyncHandler.this.state != 2) break block13;
                            rec = (ExtLogRecord)recordQueue.poll();
                            if (rec == null) {
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            intr = true;
                            continue;
                        }
                    }
                    if (AsyncHandler.this.isAutoFlush()) {
                        rec = (ExtLogRecord)recordQueue.poll();
                        if (rec == null) {
                            AsyncHandler.this.flush();
                            rec = recordQueue.take();
                        }
                    } else {
                        rec = recordQueue.take();
                    }
                    AsyncHandler.this.publishToNestedHandlers(rec);
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
                AsyncHandler.this.clearHandlers();
            }
        }
    }
}

