/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logmanager.formatters.IndentingXmlWriter;
import org.jboss.logmanager.formatters.StructuredFormatter;

public class XmlFormatter
extends StructuredFormatter {
    public static final String DEFAULT_NAMESPACE = "urn:jboss:logmanager:formatter:1.0";
    private final XMLOutputFactory factory = XMLOutputFactory.newFactory();
    private volatile boolean prettyPrint = false;
    private volatile boolean printNamespace = false;
    private volatile String namespaceUri;

    public XmlFormatter() {
        this.namespaceUri = DEFAULT_NAMESPACE;
    }

    public XmlFormatter(String keyOverrides) {
        super(keyOverrides);
        this.namespaceUri = keyOverrides == null || keyOverrides.isEmpty() ? DEFAULT_NAMESPACE : null;
    }

    public XmlFormatter(Map<StructuredFormatter.Key, String> keyOverrides) {
        super(keyOverrides);
        this.namespaceUri = keyOverrides == null || keyOverrides.isEmpty() ? DEFAULT_NAMESPACE : null;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isPrintNamespace() {
        return this.printNamespace;
    }

    public void setPrintNamespace(boolean printNamespace) {
        this.printNamespace = printNamespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Override
    protected StructuredFormatter.Generator createGenerator(Writer writer) throws Exception {
        XMLStreamWriter xmlWriter = this.prettyPrint ? new IndentingXmlWriter(this.factory.createXMLStreamWriter(writer)) : this.factory.createXMLStreamWriter(writer);
        return new XmlGenerator(xmlWriter);
    }

    private class XmlGenerator
    implements StructuredFormatter.Generator {
        private final XMLStreamWriter xmlWriter;

        private XmlGenerator(XMLStreamWriter xmlWriter) {
            this.xmlWriter = xmlWriter;
        }

        @Override
        public StructuredFormatter.Generator begin() throws Exception {
            this.writeStart(XmlFormatter.this.getKey(StructuredFormatter.Key.RECORD));
            if (XmlFormatter.this.printNamespace && XmlFormatter.this.namespaceUri != null) {
                this.xmlWriter.writeDefaultNamespace(XmlFormatter.this.namespaceUri);
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, Map<String, ?> value) throws Exception {
            if (value == null) {
                this.writeEmpty(key);
            } else {
                this.writeStart(key);
                for (Map.Entry<String, ?> entry : value.entrySet()) {
                    String k = entry.getKey();
                    Object v = entry.getValue();
                    if (v == null) {
                        this.writeEmpty(k);
                        continue;
                    }
                    this.add(k, String.valueOf(v));
                }
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, String value) throws Exception {
            if (value == null) {
                this.writeEmpty(key);
            } else {
                this.writeStart(key);
                this.xmlWriter.writeCharacters(value);
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator addMetaData(Map<String, String> metaData) throws Exception {
            for (Map.Entry<String, String> entry : metaData.entrySet()) {
                this.writeStart("metaData");
                this.xmlWriter.writeAttribute("key", entry.getKey());
                if (entry.getValue() != null) {
                    this.xmlWriter.writeCharacters(metaData.get(entry.getValue()));
                }
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator startObject(String key) throws Exception {
            this.writeStart(key);
            return this;
        }

        @Override
        public StructuredFormatter.Generator endObject() throws Exception {
            this.writeEnd();
            return this;
        }

        @Override
        public StructuredFormatter.Generator addAttribute(String name, int value) throws Exception {
            return this.addAttribute(name, Integer.toString(value));
        }

        @Override
        public StructuredFormatter.Generator addAttribute(String name, String value) throws Exception {
            this.xmlWriter.writeAttribute(name, value);
            return this;
        }

        @Override
        public StructuredFormatter.Generator end() throws Exception {
            this.writeEnd();
            this.safeFlush(this.xmlWriter);
            this.safeClose(this.xmlWriter);
            return this;
        }

        @Override
        public boolean wrapArrays() {
            return true;
        }

        private void writeEmpty(String name) throws XMLStreamException {
            this.xmlWriter.writeEmptyElement(name);
        }

        private void writeStart(String name) throws XMLStreamException {
            this.xmlWriter.writeStartElement(name);
        }

        private void writeEnd() throws XMLStreamException {
            this.xmlWriter.writeEndElement();
        }

        private void safeFlush(XMLStreamWriter flushable) {
            if (flushable != null) {
                try {
                    flushable.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void safeClose(XMLStreamWriter closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

