/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.logmanager.Logger;

public class ContextConfiguration {
    public static final Logger.AttachmentKey<ContextConfiguration> CONTEXT_CONFIGURATION_KEY = new Logger.AttachmentKey();
    private final Map<String, Supplier<ErrorManager>> errorManagers = new ConcurrentHashMap<String, Supplier<ErrorManager>>();
    private final Map<String, Supplier<Filter>> filters;
    private final Map<String, Supplier<Formatter>> formatters;
    private final Map<String, Supplier<Handler>> handlers = new ConcurrentHashMap<String, Supplier<Handler>>();
    private final Map<String, Supplier<Object>> objects;

    public ContextConfiguration() {
        this.formatters = new ConcurrentHashMap<String, Supplier<Formatter>>();
        this.filters = new ConcurrentHashMap<String, Supplier<Filter>>();
        this.objects = new ConcurrentHashMap<String, Supplier<Object>>();
    }

    public Supplier<ErrorManager> addErrorManager(String name, Supplier<ErrorManager> errorManager) {
        if (errorManager == null) {
            return this.removeErrorManager(name);
        }
        return this.errorManagers.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), SingletonSupplier.of(errorManager));
    }

    public Supplier<ErrorManager> removeErrorManager(String name) {
        return this.errorManagers.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasErrorManager(String name) {
        return this.errorManagers.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public ErrorManager getErrorManager(String name) {
        if (this.errorManagers.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.errorManagers.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<ErrorManager>> getErrorManagers() {
        return Collections.unmodifiableMap(this.errorManagers);
    }

    public Supplier<Handler> addHandler(String name, Supplier<Handler> handler) {
        if (handler == null) {
            return this.removeHandler(name);
        }
        return this.handlers.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), SingletonSupplier.of(handler));
    }

    public Supplier<Handler> removeHandler(String name) {
        return this.handlers.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasHandler(String name) {
        return this.handlers.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Handler getHandler(String name) {
        if (this.handlers.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.handlers.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<Handler>> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public Supplier<Formatter> addFormatter(String name, Supplier<Formatter> formatter) {
        if (formatter == null) {
            return this.removeFormatter(name);
        }
        return this.formatters.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), SingletonSupplier.of(formatter));
    }

    public Supplier<Formatter> removeFormatter(String name) {
        return this.formatters.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasFormatter(String name) {
        return this.formatters.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Formatter getFormatter(String name) {
        if (this.formatters.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.formatters.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<Formatter>> getFormatters() {
        return Collections.unmodifiableMap(this.formatters);
    }

    public Supplier<Filter> addFilter(String name, Supplier<Filter> filter) {
        if (filter == null) {
            return this.removeFilter(name);
        }
        return this.filters.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), SingletonSupplier.of(filter));
    }

    public Supplier<Filter> removeFilter(String name) {
        return this.filters.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasFilter(String name) {
        return this.filters.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Filter getFilter(String name) {
        if (this.filters.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.filters.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<Filter>> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    public Supplier<Object> addObject(String name, Supplier<Object> object) {
        if (object == null) {
            return this.removeObject(name);
        }
        return this.objects.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), SingletonSupplier.of(object));
    }

    public Supplier<Object> removeObject(String name) {
        return this.objects.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasObject(String name) {
        return this.objects.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Object getObject(String name) {
        if (this.objects.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.objects.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<Object>> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    private static class SingletonSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private volatile T instance;

        private SingletonSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        static <T> Supplier<T> of(Supplier<T> supplier) {
            return new SingletonSupplier<T>(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.instance == null) {
                SingletonSupplier singletonSupplier = this;
                synchronized (singletonSupplier) {
                    if (this.instance == null) {
                        this.instance = this.supplier.get();
                    }
                }
            }
            return this.instance;
        }
    }
}

