/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.ref.Reference;
import io.smallrye.common.ref.References;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.CopyOnWriteWeakMap;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContextInitializer;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.LoggerNode;

public final class LogContext
implements AutoCloseable {
    private static final LogContext SYSTEM_CONTEXT = new LogContext(false, LogContext.discoverDefaultInitializer());
    static final Permission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createLogContext", null);
    static final Permission SET_CONTEXT_SELECTOR_PERMISSION = new RuntimePermission("setLogContextSelector", null);
    static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private final LoggerNode rootLogger;
    private final boolean strong;
    private final LogContextInitializer initializer;
    private Logger.AttachmentKey<?> attachmentKey1;
    private Object attachmentValue1;
    private Logger.AttachmentKey<?> attachmentKey2;
    private Object attachmentValue2;
    private final AtomicReference<Map<String, Reference<java.util.logging.Level, Void>>> levelMapReference;
    private final Set<AutoCloseable> closeHandlers;
    final ReentrantLock treeLock = new ReentrantLock();
    public static final LogContextSelector DEFAULT_LOG_CONTEXT_SELECTOR;
    private static volatile LogContextSelector logContextSelector;

    private static LogContextInitializer discoverDefaultInitializer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(LogContext::discoverDefaultInitializer0);
        }
        return LogContext.discoverDefaultInitializer0();
    }

    private static LogContextInitializer discoverDefaultInitializer0() {
        ServiceLoader<LogContextInitializer> loader = ServiceLoader.load(LogContextInitializer.class, LogContext.class.getClassLoader());
        Iterator<LogContextInitializer> iterator = loader.iterator();
        return iterator.hasNext() ? iterator.next() : LogContextInitializer.DEFAULT;
    }

    LogContext(boolean strong, LogContextInitializer initializer) {
        this.initializer = initializer;
        this.strong = strong || initializer.useStrongReferences();
        this.levelMapReference = new AtomicReference<HashMap<String, Reference<java.util.logging.Level, Void>>>(LazyHolder.INITIAL_LEVEL_MAP);
        this.rootLogger = new LoggerNode(this);
        this.closeHandlers = new LinkedHashSet<AutoCloseable>();
    }

    public static LogContext create(boolean strong) {
        return LogContext.create(strong, LogContextInitializer.DEFAULT);
    }

    public static LogContext create(boolean strong, LogContextInitializer initializer) {
        Assert.checkNotNullParam((String)"initializer", (Object)initializer);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        return new LogContext(strong, initializer);
    }

    public static LogContext create() {
        return LogContext.create(false);
    }

    public static LogContext create(LogContextInitializer initializer) {
        return LogContext.create(false, initializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getAttachment(Logger.AttachmentKey<V> key) {
        Assert.checkNotNullParam((String)"key", key);
        LogContext logContext = this;
        synchronized (logContext) {
            if (key == this.attachmentKey1) {
                return (V)this.attachmentValue1;
            }
            if (key == this.attachmentKey2) {
                return (V)this.attachmentValue2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V attach(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        Object old;
        LogContext.checkAccess();
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        LogContext logContext = this;
        synchronized (logContext) {
            if (key == this.attachmentKey1) {
                old = this.attachmentValue1;
                this.attachmentValue1 = value;
            } else if (key == this.attachmentKey2) {
                old = this.attachmentValue2;
                this.attachmentValue2 = value;
            } else if (this.attachmentKey1 == null) {
                old = null;
                this.attachmentKey1 = key;
                this.attachmentValue1 = value;
            } else if (this.attachmentKey2 == null) {
                old = null;
                this.attachmentKey2 = key;
                this.attachmentValue2 = value;
            } else {
                throw LoggerNode.attachmentsFull();
            }
        }
        return (V)old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        Object old;
        LogContext.checkAccess();
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        LogContext logContext = this;
        synchronized (logContext) {
            if (key == this.attachmentKey1) {
                old = this.attachmentValue1;
            } else if (key == this.attachmentKey2) {
                old = this.attachmentValue2;
            } else if (this.attachmentKey1 == null) {
                old = null;
                this.attachmentKey1 = key;
                this.attachmentValue1 = value;
            } else if (this.attachmentKey2 == null) {
                old = null;
                this.attachmentKey2 = key;
                this.attachmentValue2 = value;
            } else {
                throw LoggerNode.attachmentsFull();
            }
        }
        return (V)old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V detach(Logger.AttachmentKey<V> key) throws SecurityException {
        Object old;
        LogContext.checkAccess();
        Assert.checkNotNullParam((String)"key", key);
        LogContext logContext = this;
        synchronized (logContext) {
            if (key == this.attachmentKey1) {
                old = this.attachmentValue1;
                this.attachmentValue1 = null;
            } else if (key == this.attachmentKey2) {
                old = this.attachmentValue2;
                this.attachmentValue2 = null;
            } else {
                old = null;
            }
        }
        return (V)old;
    }

    public Logger getLogger(String name) {
        return this.rootLogger.getOrCreate(name).createLogger();
    }

    public Logger getLoggerIfExists(String name) {
        LoggerNode node = this.rootLogger.getIfExists(name);
        return node == null ? null : node.createLogger();
    }

    public <V> V getAttachment(String loggerName, Logger.AttachmentKey<V> key) {
        LoggerNode node = this.rootLogger.getIfExists(loggerName);
        if (node == null) {
            return null;
        }
        return node.getAttachment(key);
    }

    public java.util.logging.Level getLevelForName(String name) throws IllegalArgumentException {
        java.util.logging.Level level;
        Map<String, Reference<java.util.logging.Level, Void>> map;
        Reference<java.util.logging.Level, Void> levelRef;
        if (name != null && (levelRef = (map = this.levelMapReference.get()).get(name)) != null && (level = (java.util.logging.Level)levelRef.get()) != null) {
            return level;
        }
        throw new IllegalArgumentException("Unknown level \"" + name + "\"");
    }

    public void registerLevel(java.util.logging.Level level) {
        this.registerLevel(level, false);
    }

    public void registerLevel(java.util.logging.Level level, boolean strong) {
        HashMap<String, Object> newLevelMap;
        Map<String, Reference<java.util.logging.Level, Void>> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            oldLevelMap = this.levelMapReference.get();
            newLevelMap = new HashMap<String, Object>(oldLevelMap.size());
            for (Map.Entry<String, Reference<java.util.logging.Level, Void>> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                Reference<java.util.logging.Level, Void> levelRef = entry.getValue();
                if (levelRef.get() == null) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), References.create((Reference.Type)(strong ? Reference.Type.STRONG : Reference.Type.WEAK), (Object)level, null));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public void unregisterLevel(java.util.logging.Level level) {
        HashMap<String, Object> newLevelMap;
        Map<String, Reference<java.util.logging.Level, Void>> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            Reference<java.util.logging.Level, Void> oldRef;
            if ((oldRef = (oldLevelMap = this.levelMapReference.get()).get(level.getName())) == null || oldRef.get() != level) {
                return;
            }
            newLevelMap = new HashMap<String, Object>(oldLevelMap.size());
            for (Map.Entry<String, Reference<java.util.logging.Level, Void>> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                Reference<java.util.logging.Level, Void> levelRef = entry.getValue();
                java.util.logging.Level oldLevel = (java.util.logging.Level)levelRef.get();
                if (oldLevel == null || oldLevel == level) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), References.create((Reference.Type)Reference.Type.WEAK, (Object)level, null));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public static LogContext getSystemLogContext() {
        return SYSTEM_CONTEXT;
    }

    public static LogContext getLogContext() {
        return logContextSelector.getLogContext();
    }

    public static void setLogContextSelector(LogContextSelector newSelector) {
        if (newSelector == null) {
            throw new NullPointerException("newSelector is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT_SELECTOR_PERMISSION);
        }
        logContextSelector = newSelector;
    }

    public static LogContextSelector getLogContextSelector() {
        return logContextSelector;
    }

    @Override
    public void close() throws Exception {
        this.treeLock.lock();
        try {
            this.recursivelyClose(this.rootLogger);
            for (AutoCloseable handler : this.closeHandlers) {
                handler.close();
            }
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public Enumeration<String> getLoggerNames() {
        return this.rootLogger.getLoggerNames();
    }

    public void addCloseHandler(AutoCloseable closeHandler) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        this.treeLock.lock();
        try {
            this.closeHandlers.add(closeHandler);
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public Set<AutoCloseable> getCloseHandlers() {
        this.treeLock.lock();
        try {
            LinkedHashSet<AutoCloseable> linkedHashSet = new LinkedHashSet<AutoCloseable>(this.closeHandlers);
            return linkedHashSet;
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public void setCloseHandlers(Collection<AutoCloseable> closeHandlers) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        this.treeLock.lock();
        try {
            this.closeHandlers.clear();
            this.closeHandlers.addAll(closeHandlers);
        }
        finally {
            this.treeLock.unlock();
        }
    }

    private static SecurityException accessDenied() {
        return new SecurityException("Log context modification access denied");
    }

    static void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }

    LoggerNode getRootLoggerNode() {
        return this.rootLogger;
    }

    ConcurrentMap<String, LoggerNode> createChildMap() {
        return this.strong ? new CopyOnWriteMap() : new CopyOnWriteWeakMap();
    }

    LogContextInitializer getInitializer() {
        return this.initializer;
    }

    private void recursivelyClose(LoggerNode loggerNode) {
        assert (this.treeLock.isHeldByCurrentThread());
        for (LoggerNode child : loggerNode.getChildren()) {
            this.recursivelyClose(child);
        }
        loggerNode.close();
    }

    static {
        logContextSelector = DEFAULT_LOG_CONTEXT_SELECTOR = new LogContextSelector(){

            @Override
            public LogContext getLogContext() {
                return SYSTEM_CONTEXT;
            }
        };
    }

    private static final class LazyHolder {
        private static final HashMap<String, Reference<java.util.logging.Level, Void>> INITIAL_LEVEL_MAP;

        private LazyHolder() {
        }

        private static void addStrong(Map<String, Reference<java.util.logging.Level, Void>> map, java.util.logging.Level level) {
            map.put(level.getName().toUpperCase(), (Reference<java.util.logging.Level, Void>)References.create((Reference.Type)Reference.Type.STRONG, (Object)level, null));
        }

        static {
            HashMap<String, Reference<java.util.logging.Level, Void>> map = new HashMap<String, Reference<java.util.logging.Level, Void>>();
            LazyHolder.addStrong(map, java.util.logging.Level.OFF);
            LazyHolder.addStrong(map, java.util.logging.Level.ALL);
            LazyHolder.addStrong(map, java.util.logging.Level.SEVERE);
            LazyHolder.addStrong(map, java.util.logging.Level.WARNING);
            LazyHolder.addStrong(map, java.util.logging.Level.CONFIG);
            LazyHolder.addStrong(map, java.util.logging.Level.INFO);
            LazyHolder.addStrong(map, java.util.logging.Level.FINE);
            LazyHolder.addStrong(map, java.util.logging.Level.FINER);
            LazyHolder.addStrong(map, java.util.logging.Level.FINEST);
            LazyHolder.addStrong(map, Level.FATAL);
            LazyHolder.addStrong(map, Level.ERROR);
            LazyHolder.addStrong(map, Level.WARN);
            LazyHolder.addStrong(map, Level.INFO);
            LazyHolder.addStrong(map, Level.DEBUG);
            LazyHolder.addStrong(map, Level.TRACE);
            INITIAL_LEVEL_MAP = map;
        }
    }
}

