/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Permission;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Protectable;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.handlers.FlushableCloseable;

public abstract class ExtHandler
extends Handler
implements FlushableCloseable,
Protectable {
    private static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private static final ErrorManager DEFAULT_ERROR_MANAGER = new OnlyOnceErrorManager();
    private volatile boolean autoFlush = true;
    private volatile boolean enabled = true;
    private volatile boolean closeChildren;
    private volatile Charset charset = Charset.defaultCharset();
    private volatile Object protectKey;
    private final ThreadLocal<Boolean> granted = new InheritableThreadLocal<Boolean>();
    private static final AtomicReferenceFieldUpdater<ExtHandler, Object> protectKeyUpdater = AtomicReferenceFieldUpdater.newUpdater(ExtHandler.class, Object.class, "protectKey");
    protected volatile Handler[] handlers;
    protected static final AtomicArray<ExtHandler, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(ExtHandler.class, Handler[].class, "handlers"), Handler.class);

    protected ExtHandler() {
        handlersUpdater.clear(this);
        this.closeChildren = true;
        super.setErrorManager(DEFAULT_ERROR_MANAGER);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    public void publish(ExtLogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            this.doPublish(record);
        }
    }

    protected void doPublish(ExtLogRecord record) {
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void addHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess(this);
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        handlersUpdater.add(this, handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess(this);
        if (handler == null) {
            return;
        }
        handlersUpdater.remove(this, handler, true);
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] clearHandlers() throws SecurityException {
        ExtHandler.checkAccess(this);
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        if (newHandlers == null) {
            throw new IllegalArgumentException("newHandlers is null");
        }
        if (newHandlers.length == 0) {
            return this.clearHandlers();
        }
        ExtHandler.checkAccess(this);
        Handler[] handlers = handlersUpdater.getAndSet(this, (Handler[])newHandlers);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SecurityException {
        ExtHandler.checkAccess(this);
        this.autoFlush = autoFlush;
        if (autoFlush) {
            this.flush();
        }
    }

    public final void setEnabled(boolean enabled) throws SecurityException {
        ExtHandler.checkAccess(this);
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCloseChildren() {
        return this.closeChildren;
    }

    public void setCloseChildren(boolean closeChildren) {
        ExtHandler.checkAccess(this);
        this.closeChildren = closeChildren;
    }

    @Override
    public final void protect(Object protectionKey) throws SecurityException {
        if (protectKeyUpdater.compareAndSet(this, null, protectionKey)) {
            return;
        }
        throw new SecurityException("Log handler already protected");
    }

    @Override
    public final void unprotect(Object protectionKey) throws SecurityException {
        if (protectKeyUpdater.compareAndSet(this, protectionKey, null)) {
            return;
        }
        throw ExtHandler.accessDenied();
    }

    @Override
    public final void enableAccess(Object protectKey) {
        if (protectKey == this.protectKey) {
            this.granted.set(Boolean.TRUE);
        }
    }

    @Override
    public final void disableAccess() {
        this.granted.remove();
    }

    private static SecurityException accessDenied() {
        return new SecurityException("Log handler modification access denied");
    }

    @Deprecated
    protected static void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }

    protected static void checkAccess(ExtHandler handler) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        if (handler.protectKey != null && handler.granted.get() == null) {
            throw ExtHandler.accessDenied();
        }
    }

    @Override
    public void flush() {
        for (Handler handler : this.handlers) {
            try {
                handler.flush();
            }
            catch (Exception ex) {
                this.reportError("Failed to flush child handler", ex, 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        ExtHandler.checkAccess(this);
        if (this.closeChildren) {
            for (Handler handler : this.handlers) {
                try {
                    handler.close();
                }
                catch (Exception ex) {
                    this.reportError("Failed to close child handler", ex, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        ExtHandler.checkAccess(this);
        super.setFormatter(newFormatter);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        ExtHandler.checkAccess(this);
        super.setFilter(newFilter);
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        try {
            this.setCharset(Charset.forName(encoding));
        }
        catch (IllegalArgumentException e) {
            UnsupportedEncodingException e2 = new UnsupportedEncodingException("Unable to set encoding to \"" + encoding + "\"");
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public String getEncoding() {
        return this.getCharset().name();
    }

    public void setCharset(Charset charset) throws SecurityException {
        ExtHandler.checkAccess(this);
        this.setCharsetPrivate(charset);
    }

    protected void setCharsetPrivate(Charset charset) throws SecurityException {
        Objects.requireNonNull(charset, "charset");
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        ExtHandler.checkAccess(this);
        super.setErrorManager(em);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        ExtHandler.checkAccess(this);
        super.setLevel(newLevel);
    }

    public boolean isCallerCalculationRequired() {
        Formatter formatter = this.getFormatter();
        if (ExtHandler.formatterRequiresCallerCalculation(formatter)) {
            return true;
        }
        for (Handler handler : this.getHandlers()) {
            if (!(handler instanceof ExtHandler ? ((ExtHandler)handler).isCallerCalculationRequired() : ExtHandler.formatterRequiresCallerCalculation(formatter = handler.getFormatter()))) continue;
            return true;
        }
        return false;
    }

    private static boolean formatterRequiresCallerCalculation(Formatter formatter) {
        return formatter != null && (!(formatter instanceof ExtFormatter) || ((ExtFormatter)formatter).isCallerCalculationRequired());
    }
}

