/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.jboss.logmanager.handlers.FlushableCloseable;

public class TcpOutputStream
extends OutputStream
implements FlushableCloseable {
    private static final long retryTimeout = 5L;
    private static final long maxRetryTimeout = 40L;
    private static final int maxErrors = 10;
    protected final Object outputLock = new Object();
    private final SocketFactory socketFactory;
    private final InetAddress address;
    private final int port;
    private final Deque<Exception> errors = new ArrayDeque<Exception>(10);
    private Thread reconnectThread;
    private boolean blockOnReconnect;
    private Socket socket;
    private boolean connected;

    public TcpOutputStream(InetAddress address, int port) throws IOException {
        this(SocketFactory.getDefault(), address, port);
    }

    public TcpOutputStream(InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this(SocketFactory.getDefault(), address, port, blockOnReconnect);
    }

    @Deprecated
    protected TcpOutputStream(Socket socket) {
        this.socketFactory = null;
        this.address = null;
        this.port = -1;
        this.socket = socket;
        this.reconnectThread = null;
        this.connected = true;
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port) throws IOException {
        this(socketFactory, address, port, false);
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.blockOnReconnect = blockOnReconnect;
        if (blockOnReconnect) {
            this.socket = socketFactory.createSocket(address, port);
        } else {
            try {
                this.socket = socketFactory.createSocket(address, port);
            }
            catch (IOException e) {
                this.reconnectThread = this.createThread();
                this.reconnectThread.start();
            }
        }
        this.connected = true;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            try {
                if (this.connected) {
                    this.socket.getOutputStream().write(b, off, len);
                }
            }
            catch (SocketException e) {
                if (this.socketFactory != null && this.reconnectThread == null) {
                    this.reconnectThread = this.createThread();
                    this.addError(e);
                    this.connected = false;
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.blockOnReconnect) {
                        this.reconnectThread.run();
                        this.write(b, off, len);
                    } else {
                        this.reconnectThread.start();
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            try {
                this.socket.getOutputStream().flush();
            }
            catch (SocketException e) {
                if (this.socketFactory != null && this.reconnectThread == null) {
                    this.reconnectThread = this.createThread();
                    this.addError(e);
                    this.connected = false;
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.blockOnReconnect) {
                        this.reconnectThread.run();
                    } else {
                        this.reconnectThread.start();
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockOnReconnect() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.blockOnReconnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockOnReconnect(boolean blockOnReconnect) {
        Object object = this.outputLock;
        synchronized (object) {
            this.blockOnReconnect = blockOnReconnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Exception> getErrors() {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (!this.errors.isEmpty()) {
                ArrayList<Exception> result = new ArrayList<Exception>(this.errors);
                this.errors.clear();
                return result;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(Exception e) {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (this.errors.size() < 10) {
                this.errors.addLast(e);
            }
        }
    }

    private Thread createThread() {
        Thread thread = new Thread(new RetryConnector());
        thread.setDaemon(true);
        thread.setName("LogManager Socket Reconnect Thread");
        return thread;
    }

    private class RetryConnector
    implements Runnable {
        private int attempts = 0;

        private RetryConnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TcpOutputStream.this.socketFactory != null) {
                try {
                    Socket socket = TcpOutputStream.this.socketFactory.createSocket(TcpOutputStream.this.address, TcpOutputStream.this.port);
                    Object object = TcpOutputStream.this.outputLock;
                    synchronized (object) {
                        TcpOutputStream.this.socket = socket;
                        TcpOutputStream.this.connected = true;
                        TcpOutputStream.this.reconnectThread = null;
                    }
                }
                catch (IOException e) {
                    TcpOutputStream.this.addError(e);
                    long timeout = (long)this.attempts++ > 0L ? (long)(10 * this.attempts) : 5L;
                    try {
                        TimeUnit.SECONDS.sleep(Math.min(timeout, 40L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.run();
                }
            }
        }
    }
}

