/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.logmanager.ConfigurationLocator;

public final class DefaultConfigurationLocator
implements ConfigurationLocator {
    public InputStream findConfiguration() throws IOException {
        ClassLoader tccl;
        String propLoc = System.getProperty("logging.configuration");
        if (propLoc != null) {
            try {
                return new URL(propLoc).openStream();
            }
            catch (IOException e) {
                System.err.printf("Unable to read the logging configuration from '%s' (%s)\n", propLoc, e);
            }
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                InputStream stream = tccl.getResourceAsStream("logging.properties");
                if (stream != null) {
                    return stream;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getClass().getResourceAsStream("logging.properties");
    }
}

