/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.ArrayList;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.Formatters;

public final class FormatStringParser {
    private static final Pattern pattern = Pattern.compile("([^%]++)|(?:%(?:(-)?(\\d+))?(?:\\.(\\d+))?(.)(?:\\{([^}]*)\\})?)");

    private FormatStringParser() {
    }

    public static FormatStep[] getSteps(String formatString) {
        long time = System.currentTimeMillis();
        ArrayList<FormatStep> stepList = new ArrayList<FormatStep>();
        Matcher matcher = pattern.matcher(formatString);
        TimeZone timeZone = TimeZone.getDefault();
        block17: while (matcher.find()) {
            String otherText = matcher.group(1);
            if (otherText != null) {
                stepList.add(Formatters.textFormatStep(otherText));
                continue;
            }
            String hypen = matcher.group(2);
            String minWidthString = matcher.group(3);
            String maxWidthString = matcher.group(4);
            String formatCharString = matcher.group(5);
            String argument = matcher.group(6);
            int minimumWidth = minWidthString == null ? 0 : Integer.parseInt(minWidthString);
            boolean leftJustify = hypen != null;
            int maximumWidth = maxWidthString == null ? 0 : Integer.parseInt(maxWidthString);
            char formatChar = formatCharString.charAt(0);
            switch (formatChar) {
                case 'c': {
                    int count = argument == null ? 0 : Integer.parseInt(argument);
                    stepList.add(Formatters.loggerNameFormatStep(leftJustify, minimumWidth, maximumWidth, count));
                    continue block17;
                }
                case 'C': {
                    int count = argument == null ? 0 : Integer.parseInt(argument);
                    stepList.add(Formatters.classNameFormatStep(leftJustify, minimumWidth, maximumWidth, count));
                    continue block17;
                }
                case 'd': {
                    stepList.add(Formatters.dateFormatStep(timeZone, argument, leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'F': {
                    stepList.add(Formatters.fileNameFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'k': {
                    stepList.add(Formatters.resourceKeyFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'l': {
                    stepList.add(Formatters.locationInformationFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'm': {
                    stepList.add(Formatters.messageFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'n': {
                    stepList.add(Formatters.lineSeparatorFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'p': {
                    stepList.add(Formatters.levelFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'r': {
                    stepList.add(Formatters.relativeTimeFormatStep(time, leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 't': {
                    stepList.add(Formatters.threadNameFormatStep(leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'x': {
                    int count = argument == null ? 0 : Integer.parseInt(argument);
                    stepList.add(Formatters.ndcFormatStep(leftJustify, minimumWidth, maximumWidth, count));
                    continue block17;
                }
                case 'X': {
                    stepList.add(Formatters.mdcFormatStep(argument, leftJustify, minimumWidth, maximumWidth));
                    continue block17;
                }
                case 'z': {
                    timeZone = TimeZone.getTimeZone(argument);
                    continue block17;
                }
                case '%': {
                    stepList.add(Formatters.textFormatStep("%"));
                    continue block17;
                }
            }
            throw new IllegalArgumentException("Encountered an unknown format character");
        }
        return stepList.toArray(new FormatStep[stepList.size()]);
    }
}

