/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LoggingMXBean;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.LoggerNode;

final class LoggingMXBeanImpl
implements LoggingMXBean {
    private final LogContext context;

    LoggingMXBeanImpl(LogContext context) {
        this.context = context;
    }

    private void getAllNames(List<String> names, LoggerNode node) {
        Logger logger = node.getLogger();
        if (logger != null) {
            names.add(logger.getName());
        }
        for (LoggerNode loggerNode : node.getChildren()) {
            this.getAllNames(names, loggerNode);
        }
    }

    @Override
    public List<String> getLoggerNames() {
        LoggerNode node = this.context.getRootLoggerNode();
        ArrayList<String> names = new ArrayList<String>();
        this.getAllNames(names, node);
        return names;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        Logger logger = this.context.getLoggerIfExists(loggerName);
        Level level = logger == null ? null : logger.getLevel();
        return level == null ? "" : level.getName();
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        Logger logger = this.context.getLoggerIfExists(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException("logger \"" + loggerName + "\" does not exist");
        }
        logger.setLevel(levelName == null ? null : this.context.getLevelForName(levelName));
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        Logger logger = this.context.getLoggerIfExists(loggerName);
        if (logger == null) {
            return null;
        }
        Logger parent = logger.getParent();
        return parent == null ? "" : parent.getName();
    }
}

