/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.jboss.logmanager.ConfigurationLocator;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.DefaultConfigurationLocator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogManager
extends java.util.logging.LogManager {
    private final AtomicBoolean configured = new AtomicBoolean();

    public LogManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                Object outField;
                Class<Level> lc = Level.class;
                try {
                    Class<Level> clazz = lc;
                    synchronized (clazz) {
                        Field knownField = lc.getDeclaredField("known");
                        knownField.setAccessible(true);
                        ArrayList old = (ArrayList)knownField.get(null);
                        if (!(old instanceof ReadOnlyArrayList)) {
                            knownField.set(null, new ReadOnlyArrayList(old));
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Class<?> traceManagerClass = Class.forName("com.sun.jmx.trace.Trace");
                    outField = traceManagerClass.getDeclaredField("out");
                    ((Field)outField).setAccessible(true);
                    ((Field)outField).set(null, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Class<java.util.logging.LogManager> lmc = java.util.logging.LogManager.class;
                try {
                    outField = lmc;
                    synchronized (outField) {
                        Field loggingMXBean = lmc.getDeclaredField("loggingMXBean");
                        loggingMXBean.setAccessible(true);
                        loggingMXBean.set(null, LogContext.getSystemLogContext().getLoggingMXBean());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        this.checkAccess();
        if (this.configured.getAndSet(true)) {
            return;
        }
        String confLocClassName = System.getProperty("org.jboss.logmanager.configurationLocator", DefaultConfigurationLocator.class.getName());
        ConfigurationLocator locator = LogManager.construct(ConfigurationLocator.class, confLocClassName);
        InputStream configuration = locator.findConfiguration();
        if (configuration != null) {
            this.readConfiguration(configuration);
        }
    }

    @Override
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        String confClassName = System.getProperty("org.jboss.logmanager.configurator", PropertyConfigurator.class.getName());
        Configurator configurator = LogManager.construct(Configurator.class, confClassName);
        try {
            configurator.configure(inputStream);
            LogContext.getSystemLogContext().getLogger("").attach(Configurator.ATTACHMENT_KEY, configurator);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static <T> T construct(Class<? extends T> type, String className) throws IOException {
        try {
            Class<?> clazz = null;
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null) {
                    clazz = Class.forName(className, true, tccl);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = Class.forName(className, true, LogManager.class.getClassLoader());
            }
            return type.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to load configuration class " + className);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                throw new NoSuchElementException("No elements");
            }
        };
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger) {
        return false;
    }

    @Override
    public Logger getLogger(String name) {
        return LogContext.getLogContext().getLogger(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnlyArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -6048215349511680936L;

        private ReadOnlyArrayList(Collection<? extends T> c) {
            super(c);
        }

        @Override
        public T set(int index, T element) {
            return null;
        }

        @Override
        public T remove(int index) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator superIter = super.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            final ListIterator superIter = super.listIterator(index);
            return new ListIterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public boolean hasPrevious() {
                    return superIter.hasPrevious();
                }

                @Override
                public T previous() {
                    return superIter.previous();
                }

                @Override
                public int nextIndex() {
                    return superIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return superIter.previousIndex();
                }

                @Override
                public void remove() {
                }

                @Override
                public void set(T o) {
                }

                @Override
                public void add(T o) {
                }
            };
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }
    }
}

