/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.FormatStep;

public final class Formatters {
    private static final Formatter NULL_FORMATTER = new Formatter(){

        public String format(LogRecord record) {
            return "";
        }
    };
    private static final String separatorString = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    private Formatters() {
    }

    public static Formatter nullFormatter() {
        return NULL_FORMATTER;
    }

    public static FormatStep textFormatStep(final String string) {
        return new FormatStep(){

            public void render(StringBuilder builder, ExtLogRecord record) {
                builder.append(string);
            }

            public int estimateLength() {
                return string.length();
            }
        };
    }

    private static String applySegments(int count, String subject) {
        if (count == 0) {
            return subject;
        }
        int idx = subject.length() + 1;
        for (int i = 0; i < count; ++i) {
            if ((idx = subject.lastIndexOf(46, idx - 1)) != -1) continue;
            return subject;
        }
        return subject.substring(idx + 1);
    }

    public static FormatStep loggerNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, maximumWidth, count){

            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getLoggerName();
            }
        };
    }

    public static FormatStep classNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, maximumWidth, count){

            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getSourceClassName();
            }
        };
    }

    public static FormatStep dateFormatStep(String formatString, boolean leftJustify, int minimumWidth, int maximumWidth) {
        final SimpleDateFormat dateFormatMaster = new SimpleDateFormat(formatString);
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getSubject(ExtLogRecord record) {
                SimpleDateFormat dateFormat;
                SimpleDateFormat simpleDateFormat = dateFormat = dateFormatMaster;
                synchronized (simpleDateFormat) {
                    return dateFormat.format(new Date(record.getMillis()));
                }
            }
        };
    }

    public static FormatStep fileNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return record.getSourceFileName();
            }
        };
    }

    public static FormatStep locationInformationFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                String fileName = record.getSourceFileName();
                int lineNumber = record.getSourceLineNumber();
                String className = record.getSourceClassName();
                String methodName = record.getSourceMethodName();
                StringBuilder builder = new StringBuilder(fileName.length() + className.length() + methodName.length() + 16);
                builder.append(className).append('.').append(methodName);
                builder.append('(').append(fileName);
                if (lineNumber != -1) {
                    builder.append(':').append(lineNumber);
                }
                builder.append(')');
                return builder.toString();
            }
        };
    }

    public static FormatStep lineNumberFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return Integer.toString(record.getSourceLineNumber());
            }
        };
    }

    public static FormatStep messageFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return record.getFormattedMessage();
            }
        };
    }

    public static FormatStep methodNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return record.getSourceMethodName();
            }
        };
    }

    public static FormatStep lineSeparatorFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return separatorString;
            }
        };
    }

    public static FormatStep levelFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                Level level = record.getLevel();
                return level.getResourceBundleName() != null ? level.getLocalizedName() : level.getName();
            }
        };
    }

    public static FormatStep relativeTimeFormatStep(final long baseTime, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return Long.toString(record.getMillis() - baseTime);
            }
        };
    }

    public static FormatStep threadNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                return record.getThreadName();
            }
        };
    }

    public static FormatStep ndcFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                String value = record.getNdc();
                return value == null ? "" : value;
            }
        };
    }

    public static FormatStep mdcFormatStep(final String key, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            public String getSubject(ExtLogRecord record) {
                String value = record.getMdc(key);
                return value == null ? "" : value;
            }
        };
    }

    private static abstract class SegmentedFormatStep
    extends JustifyingFormatStep {
        private final int count;

        protected SegmentedFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
            super(leftJustify, minimumWidth, maximumWidth);
            this.count = count;
        }

        public final String getSubject(ExtLogRecord record) {
            return Formatters.applySegments(this.count, this.getSegmentedSubject(record));
        }

        public abstract String getSegmentedSubject(ExtLogRecord var1);
    }

    private static abstract class JustifyingFormatStep
    implements FormatStep {
        private final boolean leftJustify;
        private final int minimumWidth;
        private final int maximumWidth;

        protected JustifyingFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
            if (maximumWidth != 0 && minimumWidth > maximumWidth) {
                throw new IllegalArgumentException("Specified minimum width may not be greater than the specified maximum width");
            }
            if (maximumWidth < 0 || minimumWidth < 0) {
                throw new IllegalArgumentException("Minimum and maximum widths must not be less than zero");
            }
            this.leftJustify = leftJustify;
            this.minimumWidth = minimumWidth;
            this.maximumWidth = maximumWidth == 0 ? Integer.MAX_VALUE : maximumWidth;
        }

        public void render(StringBuilder builder, ExtLogRecord record) {
            String subject = this.getSubject(record);
            int len = subject.length();
            int minimumWidth = this.minimumWidth;
            int maximumWidth = this.maximumWidth;
            if (len > maximumWidth) {
                builder.append(subject.substring(len - maximumWidth));
            } else if (len < minimumWidth) {
                if (this.leftJustify) {
                    builder.append(subject);
                    int spaces = minimumWidth - len;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                } else {
                    int spaces = minimumWidth - len;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                    builder.append(subject);
                }
            } else {
                builder.append(subject);
            }
        }

        public int estimateLength() {
            if (this.maximumWidth != 0) {
                return Math.min(this.maximumWidth, this.minimumWidth * 3);
            }
            return Math.max(32, this.minimumWidth);
        }

        public abstract String getSubject(ExtLogRecord var1);
    }
}

