/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;

public class ExtLogRecord
extends LogRecord {
    private static final long serialVersionUID = -9174374711278052369L;
    private Map<String, String> mdcCopy;
    private String ndc;

    public ExtLogRecord(Level level, String msg) {
        super(level, msg);
        this.setSourceClassName(null);
        this.ndc = NDC.get();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.copyMdc();
        oos.defaultWriteObject();
    }

    public void copyMdc() {
        if (this.mdcCopy == null) {
            this.mdcCopy = MDC.copy();
        }
    }

    public String getMdc(String key) {
        Map<String, String> mdcCopy = this.mdcCopy;
        if (mdcCopy == null) {
            return MDC.get(key);
        }
        return mdcCopy.get(key);
    }

    public String getNdc() {
        return this.ndc;
    }
}

