/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Formattable;
import java.util.Locale;
import java.util.UUID;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.ColorUtil;
import org.wildfly.common.format.GeneralFlags;
import org.wildfly.common.format.NumericFlags;
import org.wildfly.common.format.Printf;

class ColorPrintf
extends Printf {
    ColorPrintf() {
        super(Locale.getDefault());
    }

    public StringBuilder formatDirect(StringBuilder destination, String format, Object ... params) {
        ColorPrintf.restoreColor(destination);
        super.formatDirect(destination, format, params);
        ColorUtil.endFgColor(destination);
        return destination;
    }

    private static void restoreColor(StringBuilder destination) {
        ColorUtil.startFgColor(destination, ColorPatternFormatter.isTrueColor(), 255, 255, 255);
    }

    protected void formatTimeTextField(StringBuilder target, TemporalAccessor ta, TemporalField field, String[] symbols, GeneralFlags genFlags, int width) {
        super.formatTimeTextField(target, ta, field, symbols, genFlags, width);
    }

    protected void formatTimeZoneId(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        super.formatTimeZoneId(target, ta, genFlags, width);
    }

    protected void formatTimeZoneOffset(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        super.formatTimeZoneOffset(target, ta, genFlags, width);
    }

    protected void formatTimeField(StringBuilder target, TemporalAccessor ta, TemporalField field, GeneralFlags genFlags, int width, int zeroPad) {
        super.formatTimeField(target, ta, field, genFlags, width, zeroPad);
    }

    protected void formatPercent(StringBuilder target) {
        super.formatPercent(target);
    }

    protected void formatLineSeparator(StringBuilder target) {
        super.formatLineSeparator(target);
    }

    protected void formatFormattableString(StringBuilder target, Formattable formattable, GeneralFlags genFlags, int width, int precision) {
        super.formatFormattableString(target, formattable, genFlags, width, precision);
    }

    protected void formatPlainString(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        if (item instanceof Class || item instanceof Executable || item instanceof Field) {
            ColorUtil.startFgColor(target, ColorPatternFormatter.isTrueColor(), 255, 255, 221);
        } else if (item instanceof UUID) {
            ColorUtil.startFgColor(target, ColorPatternFormatter.isTrueColor(), 221, 255, 221);
        } else {
            ColorUtil.startFgColor(target, ColorPatternFormatter.isTrueColor(), 221, 221, 221);
        }
        super.formatPlainString(target, item, genFlags, width, precision);
        ColorPrintf.restoreColor(target);
    }

    protected void formatBoolean(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        super.formatBoolean(target, item, genFlags, width, precision);
    }

    protected void formatHashCode(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        super.formatHashCode(target, item, genFlags, width, precision);
    }

    protected void formatCharacter(StringBuilder target, int codePoint, GeneralFlags genFlags, int width, int precision) {
        super.formatCharacter(target, codePoint, genFlags, width, precision);
    }

    protected void formatDecimalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatDecimalInteger(target, item, genFlags, numFlags, width);
    }

    protected void formatOctalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatOctalInteger(target, item, genFlags, numFlags, width);
    }

    protected void formatHexInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatHexInteger(target, item, genFlags, numFlags, width);
    }

    protected void formatFloatingPointSci(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointSci(target, item, genFlags, numFlags, width, precision);
    }

    protected void formatFloatingPointDecimal(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointDecimal(target, item, genFlags, numFlags, width, precision);
    }

    protected void formatFloatingPointGeneral(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointGeneral(target, item, genFlags, numFlags, width, precision);
    }
}

