/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.formatters.ColorPrintf;
import org.jboss.logmanager.formatters.ColorUtil;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.wildfly.common.format.Printf;

public class ColorPatternFormatter
extends PatternFormatter {
    private final Printf printf = new ColorPrintf();
    static final boolean trueColor = ColorPatternFormatter.determineTrueColor();

    public ColorPatternFormatter() {
    }

    public ColorPatternFormatter(String pattern) {
        this.setPattern(pattern);
    }

    static boolean determineTrueColor() {
        String colorterm = System.getenv("COLORTERM");
        return colorterm != null && (colorterm.contains("truecolor") || colorterm.contains("24bit"));
    }

    static boolean isTrueColor() {
        return trueColor;
    }

    @Override
    public void setSteps(FormatStep[] steps) {
        FormatStep[] colorSteps = new FormatStep[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            colorSteps[i] = this.colorize(steps[i]);
        }
        super.setSteps(colorSteps);
    }

    private FormatStep colorize(FormatStep step) {
        switch (step.getItemType()) {
            case LEVEL: {
                return new LevelColorStep(step);
            }
            case SOURCE_CLASS_NAME: {
                return new ColorStep(step, 255, 255, 68);
            }
            case DATE: {
                return new ColorStep(step, 192, 192, 192);
            }
            case SOURCE_FILE_NAME: {
                return new ColorStep(step, 255, 255, 68);
            }
            case HOST_NAME: {
                return new ColorStep(step, 68, 255, 68);
            }
            case SOURCE_LINE_NUMBER: {
                return new ColorStep(step, 255, 255, 68);
            }
            case LINE_SEPARATOR: {
                return step;
            }
            case CATEGORY: {
                return new ColorStep(step, 68, 136, 255);
            }
            case MDC: {
                return new ColorStep(step, 68, 255, 170);
            }
            case MESSAGE: {
                return new ColorStep(step, 255, 255, 255);
            }
            case EXCEPTION_TRACE: {
                return new ColorStep(step, 255, 68, 68);
            }
            case SOURCE_METHOD_NAME: {
                return new ColorStep(step, 255, 255, 68);
            }
            case SOURCE_MODULE_NAME: {
                return new ColorStep(step, 136, 255, 68);
            }
            case SOURCE_MODULE_VERSION: {
                return new ColorStep(step, 68, 255, 68);
            }
            case NDC: {
                return new ColorStep(step, 68, 255, 170);
            }
            case PROCESS_ID: {
                return new ColorStep(step, 221, 187, 119);
            }
            case PROCESS_NAME: {
                return new ColorStep(step, 221, 221, 119);
            }
            case RELATIVE_TIME: {
                return new ColorStep(step, 192, 192, 192);
            }
            case RESOURCE_KEY: {
                return new ColorStep(step, 68, 255, 68);
            }
            case SYSTEM_PROPERTY: {
                return new ColorStep(step, 136, 136, 0);
            }
            case TEXT: {
                return new ColorStep(step, 208, 208, 208);
            }
            case THREAD_ID: {
                return new ColorStep(step, 68, 170, 68);
            }
            case THREAD_NAME: {
                return new ColorStep(step, 68, 170, 68);
            }
        }
        return new ColorStep(step, 176, 208, 176);
    }

    private String colorizePlain(String str) {
        return ColorUtil.endFgColor(ColorUtil.startFgColor(new StringBuilder(), ColorPatternFormatter.isTrueColor(), 255, 255, 255).append(str)).toString();
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        if (logRecord instanceof ExtLogRecord) {
            ExtLogRecord record = (ExtLogRecord)logRecord;
            if (record.getFormatStyle() != ExtLogRecord.FormatStyle.PRINTF || record.getParameters() == null || record.getParameters().length == 0) {
                return this.colorizePlain(super.formatMessage(record));
            }
            return this.printf.format(record.getMessage(), record.getParameters());
        }
        return this.colorizePlain(super.formatMessage(logRecord));
    }

    static final class LevelColorStep
    implements FormatStep {
        private static final int LARGEST_LEVEL = Level.ERROR.intValue();
        private static final int SMALLEST_LEVEL = Level.TRACE.intValue();
        private static final int SATURATION = 66;
        private final FormatStep delegate;

        LevelColorStep(FormatStep delegate) {
            this.delegate = delegate;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            int level = Math.max(Math.min(record.getLevel().intValue(), LARGEST_LEVEL), SMALLEST_LEVEL) - SMALLEST_LEVEL;
            int r = (level < 300 ? 0 : (level - 300) * 189 / 300) + 66;
            int g = (300 - Math.abs(level - 300)) * 189 / 300 + 66;
            int b = (level > 300 ? 0 : level * 189 / 300) + 66;
            ColorUtil.startFgColor(builder, ColorPatternFormatter.isTrueColor(), r, g, b);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }

        @Override
        public boolean isCallerInformationRequired() {
            return false;
        }
    }

    static final class ColorStep
    implements FormatStep {
        private final int r;
        private final int g;
        private final int b;
        private final FormatStep delegate;

        ColorStep(FormatStep delegate, int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.delegate = delegate;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            ColorUtil.startFgColor(builder, ColorPatternFormatter.isTrueColor(), this.r, this.g, this.b);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }

        @Override
        public boolean isCallerInformationRequired() {
            return this.delegate.isCallerInformationRequired();
        }

        @Override
        public FormatStep[] childSteps() {
            return this.delegate.childSteps();
        }

        @Override
        public int childStepCount() {
            return this.delegate.childStepCount();
        }

        @Override
        public FormatStep getChildStep(int idx) {
            return this.delegate.getChildStep(idx);
        }

        @Override
        public FormatStep.ItemType getItemType() {
            return this.delegate.getItemType();
        }
    }
}

