/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name = "levelRangeFilterType")
public class LevelRangeFilterMetaData extends AbstractSimpleFilterMetaData {
    private String minLevel;
    private boolean minInclusive;
    private String maxLevel;
    private boolean maxInclusive;

    public String getMinLevel() {
        return minLevel;
    }

    @XmlAttribute(name = "min-level", required = true)
    @XmlJavaTypeAdapter(PropertyReplaceAdapter.class)
    public void setMinLevel(final String minLevel) {
        this.minLevel = minLevel;
    }

    public boolean isMinInclusive() {
        return minInclusive;
    }

    @XmlAttribute(name = "min-inclusive")
    @XmlJavaTypeAdapter(PropertyReplaceAdapter.class)
    public void setMinInclusive(final boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    public String getMaxLevel() {
        return maxLevel;
    }

    @XmlAttribute(name = "max-level", required = true)
    @XmlJavaTypeAdapter(PropertyReplaceAdapter.class)
    public void setMaxLevel(final String maxLevel) {
        this.maxLevel = maxLevel;
    }

    public boolean isMaxInclusive() {
        return maxInclusive;
    }

    @XmlAttribute(name = "max-inclusive")
    @XmlJavaTypeAdapter(PropertyReplaceAdapter.class)
    public void setMaxInclusive(final boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }
}
