/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.ElementHelper;

public abstract class ClassModel {
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String GET_INSTANCE_METHOD_NAME = "readResolve";
    private final JSources sources;
    private final JClassDef classDef;
    protected final JSourceFile sourceFile;
    private final MessageInterface messageInterface;
    private final String className;
    private final String superClassName;
    private final String format;
    private final Map<String, JMethodDef> messageMethods;
    private final Map<String, JVarDeclaration> messageFields;

    ClassModel(Filer filer, MessageInterface messageInterface, String className, String superClassName) {
        this.messageInterface = messageInterface;
        this.className = messageInterface.packageName() + "." + className;
        this.superClassName = superClassName;
        this.sources = JDeparser.createSources((JFiler)JFiler.newInstance((Filer)filer), (FormatPreferences)new FormatPreferences(new Properties()));
        this.sourceFile = this.sources.createSourceFile(messageInterface.packageName(), className);
        this.classDef = this.sourceFile._class(32, className);
        int idLen = messageInterface.getIdLength();
        this.format = idLen > 0 ? "%s%0" + messageInterface.getIdLength() + "d: %s" : "%s%d: %s";
        this.messageMethods = new HashMap<String, JMethodDef>();
        this.messageFields = new HashMap<String, JVarDeclaration>();
    }

    public final MessageInterface messageInterface() {
        return this.messageInterface;
    }

    public final void generateAndWrite() throws IOException {
        this.generateModel();
        this.sources.writeSources();
        JDeparser.dropCaches();
    }

    JClassDef generateModel() throws IllegalStateException {
        this.classDef.annotate(Generated.class).value("value", this.getClass().getName()).value("date", JExprs.str((String)ClassModelHelper.generatedDateValue()));
        this.classDef.docComment().text("Warning this class consists of generated code.");
        if (this.superClassName != null) {
            this.classDef._extends(this.superClassName);
        }
        this.classDef._implements(new String[]{ElementHelper.typeToString(this.messageInterface.name())});
        if (!this.messageInterface.extendedInterfaces().isEmpty()) {
            for (MessageInterface intf : this.messageInterface.extendedInterfaces()) {
                String interfaceName = ElementHelper.typeToString(intf.name());
                this.classDef._implements(new String[]{interfaceName});
            }
        }
        return this.classDef;
    }

    JMethodDef addMessageMethod(MessageMethod messageMethod) {
        return this.addMessageMethod(messageMethod, messageMethod.message().value());
    }

    JMethodDef addMessageMethod(MessageMethod messageMethod, String messageValue) {
        if (messageValue == null) {
            return null;
        }
        String methodName = messageMethod.isOverloaded() ? messageMethod.name() + messageMethod.formatParameterCount() : messageMethod.name();
        JMethodDef method = this.messageMethods.get(messageMethod.messageMethodName());
        if (method == null) {
            JVarDeclaration field = this.messageFields.get(methodName);
            if (field == null) {
                String msg = this.messageInterface.projectCode() != null && !this.messageInterface.projectCode().isEmpty() && messageMethod.message().hasId() ? String.format(this.format, this.messageInterface.projectCode(), messageMethod.message().id(), messageValue) : messageValue;
                field = this.classDef.field(74, String.class, methodName, JExprs.str((String)msg));
                this.messageFields.put(field.name(), field);
            }
            method = this.classDef.method(16, String.class, messageMethod.messageMethodName());
            method.body()._return((JExpr)JExprs.$v((JVarDeclaration)field));
            this.messageMethods.put(messageMethod.messageMethodName(), method);
        }
        return method;
    }

    public final String qualifiedClassName() {
        return this.className;
    }

    protected JMethodDef createReadResolveMethod() {
        JType type = JTypes.typeOf((JClassDef)this.classDef);
        JVarDeclaration instance = this.classDef.field(98, type, INSTANCE_FIELD_NAME, (JExpr)type._new());
        JMethodDef readResolveMethod = this.classDef.method(16, Object.class, GET_INSTANCE_METHOD_NAME);
        readResolveMethod.body()._return((JExpr)JExprs.$v((JVarDeclaration)instance));
        return readResolveMethod;
    }
}

