/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import org.jboss.logging.generator.Annotations;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.validation.AbstractFormatValidator;
import org.jboss.logging.generator.validation.FormatValidator;
import org.jboss.logging.generator.validation.MessageFormatValidator;
import org.jboss.logging.generator.validation.StringFormatValidator;

public final class FormatValidatorFactory {
    private FormatValidatorFactory() {
    }

    public static FormatValidator create(MessageMethod messageMethod) throws IllegalStateException {
        if (messageMethod.message() == null) {
            return InvalidFormatValidator.of("No message annotation found.");
        }
        String msg = messageMethod.message().value();
        Annotations.FormatType format = messageMethod.message().format();
        if (msg == null) {
            return InvalidFormatValidator.of("A message is required for the format.");
        }
        if (format == null) {
            return InvalidFormatValidator.of("A format is required for the message.");
        }
        switch (format) {
            case MESSAGE_FORMAT: {
                return MessageFormatValidator.of(msg);
            }
            case PRINTF: {
                return StringFormatValidator.of(msg);
            }
        }
        return InvalidFormatValidator.of(String.format("Format %s is invalid.", new Object[]{format}));
    }

    private static final class InvalidFormatValidator
    extends AbstractFormatValidator {
        private InvalidFormatValidator() {
        }

        static FormatValidator of(String summaryMessage) {
            InvalidFormatValidator result = new InvalidFormatValidator();
            result.setSummaryMessage(summaryMessage);
            return result;
        }

        static FormatValidator of(String summaryMessage, String detailMessage) {
            InvalidFormatValidator result = new InvalidFormatValidator();
            result.setDetailMessage(detailMessage);
            result.setSummaryMessage(summaryMessage);
            return result;
        }

        @Override
        public String format() {
            return "";
        }

        @Override
        public int argumentCount() {
            return 0;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

