/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.generator.apt.AbstractGenerator;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.model.ClassModel;
import org.jboss.logging.generator.model.ClassModelFactory;
import org.jboss.logging.generator.util.VersionComparator;

final class ImplementationClassGenerator
extends AbstractGenerator {
    private static final String LOGGING_VERSION = "loggingVersion";
    private final boolean useLogging31;

    public ImplementationClassGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        String loggingVersion;
        Map<String, String> options = processingEnv.getOptions();
        this.useLogging31 = options.containsKey(LOGGING_VERSION) ? VersionComparator.compareVersion(loggingVersion = options.get(LOGGING_VERSION), "3.1") >= 0 : true;
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        try {
            ClassModel classModel = ClassModelFactory.implementation(messageInterface, this.useLogging31);
            classModel.create(this.filer().createSourceFile(classModel.qualifiedClassName(), new Element[0]));
        }
        catch (IOException e) {
            this.logger().error((Element)element, e);
        }
        catch (IllegalStateException e) {
            this.logger().error((Element)element, e);
        }
    }
}

