/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.lang.model.element.Element;

class AtpException
extends RuntimeException {
    private final Element element;
    private final Throwable cause;

    public AtpException(Element element, String msg) {
        super(msg);
        this.element = element;
        this.cause = null;
    }

    public AtpException(Element element, String msg, Throwable cause) {
        super(msg, cause);
        this.element = element;
        this.cause = cause;
    }

    public static AtpException of(Element element, String msg) {
        return new AtpException(element, msg);
    }

    public static AtpException of(Element element, String format, Object ... args) {
        return new AtpException(element, String.format(format, args));
    }

    public static AtpException of(Element element, Throwable cause, String msg) {
        return new AtpException(element, msg, cause);
    }

    public static AtpException of(Element element, Throwable cause, String format, Object ... args) {
        return new AtpException(element, String.format(format, args), cause);
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            this.cause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.cause != null) {
            this.cause.printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.cause != null) {
            this.cause.printStackTrace(pw);
        }
    }
}

