/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import org.jboss.logging.generator.intf.model.MessageObject;
import org.jboss.logging.generator.validation.ValidationMessage;

public final class ValidationMessageFactory {
    private ValidationMessageFactory() {
    }

    public static ValidationMessage createError(MessageObject messageObject, String message) {
        return new ValidationErrorMessage(messageObject, message);
    }

    public static ValidationMessage createError(MessageObject messageObject, String format, Object ... args) {
        return new ValidationErrorMessage(messageObject, String.format(format, args));
    }

    public static ValidationMessage createWarning(MessageObject messageObject, String message) {
        return new ValidationWarningMessage(messageObject, message);
    }

    public static ValidationMessage createWarning(MessageObject messageObject, String format, Object ... args) {
        return new ValidationWarningMessage(messageObject, String.format(format, args));
    }

    private static class ValidationWarningMessage
    extends AbstractValidationMessage {
        private ValidationWarningMessage(MessageObject messageObject, String message) {
            super(messageObject, message);
        }

        @Override
        public ValidationMessage.Type type() {
            return ValidationMessage.Type.WARN;
        }
    }

    private static class ValidationErrorMessage
    extends AbstractValidationMessage {
        private ValidationErrorMessage(MessageObject messageObject, String message) {
            super(messageObject, message);
        }

        @Override
        public ValidationMessage.Type type() {
            return ValidationMessage.Type.ERROR;
        }
    }

    private static abstract class AbstractValidationMessage
    implements ValidationMessage {
        private final MessageObject messageObject;
        private final String message;

        AbstractValidationMessage(MessageObject messageObject, String message) {
            this.messageObject = messageObject;
            this.message = message;
        }

        @Override
        public final MessageObject getMessageObject() {
            return this.messageObject;
        }

        @Override
        public final String getMessage() {
            return this.message;
        }
    }
}

