/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.intf.model.ThrowableType;
import org.jboss.logging.generator.validation.FormatValidator;
import org.jboss.logging.generator.validation.FormatValidatorFactory;
import org.jboss.logging.generator.validation.MessageIdValidator;
import org.jboss.logging.generator.validation.ValidationMessage;
import org.jboss.logging.generator.validation.ValidationMessageFactory;

public final class Validator {
    public static final Validator INSTANCE = new Validator();

    private Validator() {
    }

    public final Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (messageInterface.isMessageBundle()) {
            String projectCode = messageInterface.projectCode();
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(projectCode, messageMethods));
            messages.addAll(this.validateBundle(messageMethods));
        } else if (messageInterface.isMessageLogger()) {
            String projectCode = messageInterface.projectCode();
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(projectCode, messageMethods));
            messages.addAll(this.validateLogger(messageMethods));
        } else {
            messages.add(ValidationMessageFactory.createError(messageInterface, "Message interface %s is not a message bundle or message logger.", messageInterface.name()));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateCommon(String projectCode, Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, MessageMethod> methodNames = new HashMap<String, MessageMethod>();
        for (MessageMethod messageMethod : messageMethods) {
            FormatValidator formatValidator;
            for (ThrowableType throwableType : messageMethod.thrownTypes()) {
                if (!throwableType.isChecked()) continue;
                messages.add(ValidationMessageFactory.createError(messageMethod, "Interface messageMethods cannot throw checked exceptions."));
            }
            MessageMethod.Message message = messageMethod.message();
            if (message == null) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "All message bundles and message logger messageMethods must have or inherit a message."));
                continue;
            }
            if (message.hasId()) {
                if (message.id() < 0) {
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Message id %d is invalid. Must be greater than 0 or inherit another valid id.", message.id()));
                } else {
                    messages.addAll(MessageIdValidator.INSTANCE.validate(projectCode, messageMethod));
                }
            }
            if ((formatValidator = FormatValidatorFactory.create(messageMethod)).isValid()) {
                int paramCount = messageMethod.formatParameterCount();
                if (messageMethod.formatParameterCount() != formatValidator.argumentCount()) {
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Parameter count does not match for format '%s'. Required: %d Provided: %d", formatValidator.format(), formatValidator.argumentCount(), paramCount));
                }
            } else {
                messages.add(ValidationMessageFactory.createError(messageMethod, formatValidator.summaryMessage()));
            }
            if (!messageMethod.inheritsMessage()) {
                String key = messageMethod.name() + messageMethod.formatParameterCount();
                if (methodNames.containsKey(key)) {
                    MessageMethod previousMethod = (MessageMethod)methodNames.get(key);
                    messages.add(ValidationMessageFactory.createError(previousMethod, "Only one message with the same format parameters is allowed."));
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Only one message with the same format parameters is allowed."));
                } else {
                    methodNames.put(key, messageMethod);
                }
            }
            messages.addAll(this.validateParameters(messageMethod));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateParameters(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean foundCause = false;
        ReturnType returnType = messageMethod.returnType();
        for (Parameter parameter : messageMethod.allParameters()) {
            switch (parameter.parameterType()) {
                case CAUSE: {
                    if (foundCause) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "Only one cause parameter is allowed."));
                        break;
                    }
                    foundCause = true;
                    break;
                }
                case FIELD: {
                    if (returnType.hasFieldFor(parameter)) break;
                    messages.add(ValidationMessageFactory.createError(parameter, "No target field found in %s with name %s with type %s.", returnType.type(), parameter.targetName(), parameter.type()));
                    break;
                }
                case PROPERTY: {
                    if (returnType.hasMethodFor(parameter)) break;
                    messages.add(ValidationMessageFactory.createError(parameter, "No method found in %s with signature %s(%s).", returnType.type(), parameter.targetName(), parameter.type()));
                }
            }
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundle(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            messages.addAll(this.validateBundleMethod(messageMethod));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundleMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ReturnType returnType = messageMethod.returnType();
        if (returnType.equals(ReturnType.VOID) || returnType.isPrimitive()) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "Message bundle messageMethod %s has an invalid return type. Cannot be void or a primitive.", messageMethod.name()));
        } else if (returnType.isThrowable()) {
            ThrowableType throwableReturnType;
            if (!returnType.isSubtypeOf(Throwable.class)) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "Message bundle messageMethod %s has an invalid return type of %s.", messageMethod.name(), returnType.name()));
            }
            if (!(throwableReturnType = returnType.throwableReturnType()).useConstructionParameters()) {
                if (!throwableReturnType.useConstructionParameters() && !messageMethod.constructorParameters().isEmpty()) {
                    messages.add(ValidationMessageFactory.createError(messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
                } else {
                    boolean usableConstructor;
                    boolean hasMessageConstructor = throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasStringConstructor();
                    boolean bl = usableConstructor = throwableReturnType.hasDefaultConstructor() || throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasStringConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasThrowableConstructor();
                    if (!usableConstructor) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
                    } else if (!hasMessageConstructor) {
                        messages.add(ValidationMessageFactory.createWarning(messageMethod, "The message cannot be set via the throwable constructor and will be ignored."));
                    }
                }
            }
        } else if (!returnType.isAssignableFrom(String.class)) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "Return type %s does not appear valid for a message bundle.", messageMethod.name()));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLogger(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            if (messageMethod.isLoggerMethod()) {
                messages.addAll(this.validateLoggerMethod(messageMethod));
                continue;
            }
            messages.addAll(this.validateBundleMethod(messageMethod));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLoggerMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!ReturnType.VOID.equals(messageMethod.returnType())) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "Message logger methods can only have a void return type."));
        }
        return messages;
    }

    private Set<MessageMethod> getAllMethods(MessageInterface messageInterface) {
        if (messageInterface.isLoggerInterface()) {
            return Collections.emptySet();
        }
        HashSet<MessageMethod> messageMethods = new HashSet<MessageMethod>();
        for (MessageMethod messageMethod : messageInterface.methods()) {
            messageMethods.add(messageMethod);
        }
        for (MessageInterface msgInterface : messageInterface.extendedInterfaces()) {
            messageMethods.addAll(this.getAllMethods(msgInterface));
        }
        return messageMethods;
    }
}

