/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.util;

import java.util.Comparator;

public abstract class Comparison {
    public static final int EQUAL = 0;
    public static final int LESS = -1;
    public static final int GREATER = 1;
    private static final Comparison LESS_COMPARISON = new DeadComparison(-1);
    private static final Comparison GREATER_COMPARISON = new DeadComparison(1);
    private static final Comparison ALLOW_NULL_INSTANCE = new Comparison(){

        public Comparison compare(Comparable left, Comparable right) {
            int result = left == null && right == null ? 0 : (left == null ? -1 : (right == null ? 1 : left.compareTo(right)));
            return ((Comparison)this).checkResult(result);
        }

        @Override
        public <T> Comparison compare(T left, T right, Comparator<T> comparator) {
            int result = left == null && right == null ? 0 : (left == null ? -1 : (right == null ? 1 : comparator.compare(left, right)));
            return ((Comparison)this).checkResult(result);
        }

        @Override
        public Comparison getInstance() {
            return ALLOW_NULL_INSTANCE;
        }
    };
    private static final Comparison INSTANCE = new Comparison(){

        public Comparison compare(Comparable left, Comparable right) {
            return ((Comparison)this).checkResult(left.compareTo(right));
        }

        @Override
        public <T> Comparison compare(T left, T right, Comparator<T> comparator) {
            return ((Comparison)this).checkResult(comparator.compare(left, right));
        }

        @Override
        public Comparison getInstance() {
            return INSTANCE;
        }
    };

    private Comparison() {
    }

    public static Comparison begin() {
        return INSTANCE;
    }

    public static Comparison beginAllowNull() {
        return ALLOW_NULL_INSTANCE;
    }

    public abstract Comparison compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> Comparison compare(T var1, T var2, Comparator<T> var3);

    public Comparison compare(int left, int right) {
        int result = 0;
        if (left < right) {
            result = -1;
        } else if (left > right) {
            result = 1;
        }
        return this.checkResult(result);
    }

    public Comparison compare(long left, long right) {
        int result = 0;
        if (left < right) {
            result = -1;
        } else if (left > right) {
            result = 1;
        }
        return this.checkResult(result);
    }

    public Comparison compare(float left, float right) {
        return this.checkResult(Float.compare(left, right));
    }

    public Comparison compare(double left, double right) {
        return this.checkResult(Double.compare(left, right));
    }

    public Comparison compare(boolean left, boolean right) {
        return this.checkResult(left == right ? 0 : (left ? 1 : -1));
    }

    public int result() {
        return 0;
    }

    protected abstract Comparison getInstance();

    private Comparison checkResult(int result) {
        return result < 0 ? LESS_COMPARISON : (result > 0 ? GREATER_COMPARISON : this.getInstance());
    }

    private static final class DeadComparison
    extends Comparison {
        private final int result;

        public DeadComparison(int result) {
            this.result = result;
        }

        @Override
        public Comparison compare(Comparable<?> left, Comparable<?> right) {
            return this;
        }

        @Override
        public <T> Comparison compare(T left, T right, Comparator<T> comparator) {
            return this;
        }

        @Override
        public Comparison compare(int left, int right) {
            return this;
        }

        @Override
        public Comparison compare(long left, long right) {
            return this;
        }

        @Override
        public Comparison compare(float left, float right) {
            return this;
        }

        @Override
        public Comparison compare(double left, double right) {
            return this;
        }

        @Override
        public Comparison compare(boolean left, boolean right) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }

        @Override
        public Comparison getInstance() {
            return this;
        }
    }
}

