/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldRef;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.util.HashSet;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.model.ClassModelHelper;
import org.jboss.logging.generator.model.ImplementationClassModel;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";

    public MessageLoggerImplementor(MessageInterface messageInterface) {
        super(messageInterface);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JFieldRef logger;
        JCodeModel codeModel = super.generateModel();
        JFieldVar projectCodeVar = null;
        if (!this.messageInterface().projectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.messageInterface().projectCode()));
        }
        JFieldVar fqcn = this.getDefinedClass().field(28, String.class, FQCN_FIELD_NAME);
        fqcn.init((JExpression)this.getDefinedClass().dotclass().invoke("getName"));
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        if (this.messageInterface().extendsLoggerInterface()) {
            this.getDefinedClass()._extends(Tools.loggers().delegatingLogger());
            constructorBody.add((JStatement)JExpr.invoke((String)"super").arg((JExpression)constructorParam));
            logger = JExpr._super().ref(LOG_FIELD_NAME);
        } else {
            JFieldVar logVar = this.getDefinedClass().field(10, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)logVar), (JExpression)constructorParam);
            logger = logVar;
        }
        HashSet<MessageMethod> messageMethods = new HashSet<MessageMethod>();
        messageMethods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.isLoggerInterface()) continue;
            messageMethods.addAll(messageInterface.methods());
        }
        for (MessageMethod messageMethod : messageMethods) {
            JClass returnType = codeModel.ref(messageMethod.returnType().name());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, messageMethod.name());
            jMethod.annotate(Override.class);
            JMethod msgMethod = this.addMessageMethod(messageMethod);
            if (messageMethod.isLoggerMethod()) {
                this.createLoggerMethod(messageMethod, jMethod, msgMethod, (JVar)projectCodeVar, (JExpression)logger);
                continue;
            }
            this.createBundleMethod(messageMethod, jMethod, msgMethod, (JVar)projectCodeVar);
        }
        return codeModel;
    }

    private void createLoggerMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar, JExpression logger) {
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        JInvocation logInv = body.invoke(logger, messageMethod.loggerMethod());
        logInv.arg((JExpression)JExpr.ref((String)FQCN_FIELD_NAME));
        logInv.arg(JExpr.direct((String)messageMethod.logLevelParameter()));
        if (messageMethod.hasCause()) {
            logInv.arg(JExpr.direct((String)messageMethod.cause().name()));
        } else {
            logInv.arg(JExpr._null());
        }
        MessageMethod.Message message = messageMethod.message();
        if (message.hasId() && projectCodeVar != null) {
            String formattedId = ClassModelHelper.formatMessageId(message.id());
            logInv.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (Parameter param : messageMethod.allParameters()) {
            JClass paramType = this.getCodeModel().ref(param.type());
            JVar var = method.param(8, (JType)paramType, param.name());
            String formatterClass = param.formatterClass();
            switch (param.parameterType()) {
                case FORMAT: {
                    if (formatterClass == null) {
                        logInv.arg((JExpression)var);
                        break;
                    }
                    logInv.arg((JExpression)JExpr._new((JClass)this.getCodeModel().ref(formatterClass)).arg((JExpression)var));
                }
            }
        }
    }
}

