/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.Annotations;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.apt.AtpException;
import org.jboss.logging.generator.apt.ParameterFactory;
import org.jboss.logging.generator.apt.ReturnTypeFactory;
import org.jboss.logging.generator.apt.ThrowableTypeFactory;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.intf.model.ThrowableType;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Objects;

final class MessageMethodBuilder {
    private static final String MESSAGE_METHOD_SUFFIX = "$str";
    private final List<ExecutableElement> methods;
    private final Elements elements;
    private final Types types;

    private MessageMethodBuilder(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.methods = new LinkedList<ExecutableElement>();
    }

    static MessageMethodBuilder create(Elements elements, Types types) {
        return new MessageMethodBuilder(elements, types);
    }

    MessageMethodBuilder add(ExecutableElement method) {
        this.methods.add(method);
        return this;
    }

    Set<? extends MessageMethod> build() {
        LinkedHashSet<AptMessageMethod> result = new LinkedHashSet<AptMessageMethod>();
        for (ExecutableElement elementMethod : this.methods) {
            AptMessageMethod resultMethod = new AptMessageMethod(elementMethod);
            resultMethod.inheritsMessage = ElementHelper.inheritsMessage(this.methods, elementMethod);
            resultMethod.message = MessageMethodBuilder.findMessage(this.methods, elementMethod);
            resultMethod.isOverloaded = ElementHelper.isOverloaded(this.methods, elementMethod);
            for (TypeMirror typeMirror : elementMethod.getThrownTypes()) {
                resultMethod.thrownTypes.add(ThrowableTypeFactory.of(this.elements, this.types, typeMirror));
            }
            for (Parameter parameter : ParameterFactory.of(this.elements, this.types, resultMethod.method)) {
                switch (parameter.parameterType()) {
                    case CAUSE: {
                        resultMethod.cause = parameter;
                        break;
                    }
                    case CONSTRUCTION: {
                        resultMethod.constructorParameters.add(parameter);
                        break;
                    }
                    case FORMAT: {
                        resultMethod.formatParameters.add(parameter);
                        break;
                    }
                    case FIELD: 
                    case MESSAGE: 
                    case PROPERTY: {
                        break;
                    }
                    default: {
                        throw AtpException.of((Element)elementMethod, "Parameter %s is not a format parameter, a cause parameter or a throwable construction parameter.", parameter);
                    }
                }
                resultMethod.allParameters.add(parameter);
            }
            if (resultMethod.isOverloaded()) {
                resultMethod.messageMethodName = resultMethod.name() + resultMethod.formatParameterCount() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name() + "." + resultMethod.formatParameterCount();
            } else {
                resultMethod.messageMethodName = resultMethod.name() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name();
            }
            resultMethod.returnType = ReturnTypeFactory.of(this.elements, this.types, elementMethod.getReturnType(), resultMethod);
            result.add(resultMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    private static MessageMethod.Message findMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        AptMessage result = null;
        if (ElementHelper.isAnnotatedWith(method, Tools.annotations().message())) {
            result = new AptMessage();
            result.hasId = Tools.aptHelper().hasMessageId(method);
            result.value = Tools.aptHelper().messageValue(method);
            result.formatType = Tools.aptHelper().messageFormat(method);
            result.inheritsId = Tools.aptHelper().inheritsMessageId(method);
            if (result.inheritsId()) {
                result.id = MessageMethodBuilder.findMessageId(methods, method);
            } else {
                result.id = Tools.aptHelper().messageId(method);
            }
        } else {
            Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName(), ElementHelper.parameterCount(method.getParameters()));
            for (ExecutableElement m : allMethods) {
                if (!ElementHelper.isAnnotatedWith(m, Tools.annotations().message())) continue;
                result = new AptMessage();
                result.hasId = Tools.aptHelper().hasMessageId(m);
                result.value = Tools.aptHelper().messageValue(m);
                result.formatType = Tools.aptHelper().messageFormat(m);
                result.inheritsId = Tools.aptHelper().inheritsMessageId(m);
                if (result.inheritsId()) {
                    result.id = MessageMethodBuilder.findMessageId(methods, m);
                    break;
                }
                result.id = Tools.aptHelper().messageId(m);
                break;
            }
        }
        return result;
    }

    private static int findMessageId(Collection<ExecutableElement> methods, ExecutableElement method) {
        int result = -2;
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName(), ElementHelper.parameterCount(method.getParameters()));
        for (ExecutableElement m : allMethods) {
            if (!ElementHelper.isAnnotatedWith(m, Tools.annotations().message()) || Tools.aptHelper().inheritsMessageId(m)) continue;
            result = Tools.aptHelper().messageId(m);
        }
        return result;
    }

    private static class AptMessage
    implements MessageMethod.Message {
        private boolean hasId;
        private int id;
        private boolean inheritsId;
        private String value;
        private Annotations.FormatType formatType;

        private AptMessage() {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public boolean hasId() {
            return this.hasId;
        }

        @Override
        public boolean inheritsId() {
            return this.inheritsId;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Annotations.FormatType format() {
            return this.formatType;
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("hasId", this.hasId).add("id", this.id).add("inheritsId", this.inheritsId).add("value", this.value).add("formatType", (Object)this.formatType).toString();
        }
    }

    private static class AptMessageMethod
    implements MessageMethod {
        private ReturnType returnType;
        private Parameter cause;
        private boolean inheritsMessage;
        private boolean isOverloaded;
        private MessageMethod.Message message;
        private final Set<Parameter> allParameters;
        private final Set<ThrowableType> thrownTypes;
        private String messageMethodName;
        private final ExecutableElement method;
        private final Set<Parameter> formatParameters;
        private final Set<Parameter> constructorParameters;
        private String translationKey;

        AptMessageMethod(ExecutableElement method) {
            this.method = method;
            this.inheritsMessage = false;
            this.isOverloaded = false;
            this.allParameters = new LinkedHashSet<Parameter>();
            this.formatParameters = new LinkedHashSet<Parameter>();
            this.constructorParameters = new LinkedHashSet<Parameter>();
            this.thrownTypes = new LinkedHashSet<ThrowableType>();
        }

        @Override
        public MessageMethod.Message message() {
            return this.message;
        }

        @Override
        public boolean inheritsMessage() {
            return this.inheritsMessage;
        }

        @Override
        public String messageMethodName() {
            return this.messageMethodName;
        }

        @Override
        public String translationKey() {
            return this.translationKey;
        }

        @Override
        public String name() {
            return this.method.getSimpleName().toString();
        }

        @Override
        public boolean hasCause() {
            return this.cause != null;
        }

        @Override
        public boolean isOverloaded() {
            return this.isOverloaded;
        }

        @Override
        public Parameter cause() {
            return this.cause;
        }

        @Override
        public ReturnType returnType() {
            return this.returnType;
        }

        @Override
        public String loggerMethod() {
            return Tools.aptHelper().loggerMethod(this.message.format());
        }

        @Override
        public String logLevelParameter() {
            return Tools.aptHelper().logLevel(this.method);
        }

        @Override
        public Set<Parameter> allParameters() {
            return Collections.unmodifiableSet(this.allParameters);
        }

        @Override
        public Set<Parameter> formatParameters() {
            return Collections.unmodifiableSet(this.formatParameters);
        }

        @Override
        public Set<Parameter> constructorParameters() {
            return Collections.unmodifiableSet(this.constructorParameters);
        }

        @Override
        public int formatParameterCount() {
            return this.formatParameters.size();
        }

        @Override
        public boolean isLoggerMethod() {
            return ElementHelper.isAnnotatedWith(this.method, Tools.annotations().logMessage());
        }

        @Override
        public Set<ThrowableType> thrownTypes() {
            return Collections.unmodifiableSet(this.thrownTypes);
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).add(this.allParameters()).add(this.returnType()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageMethod)) {
                return false;
            }
            AptMessageMethod other = (AptMessageMethod)obj;
            return Objects.areEqual(this.name(), other.name()) && Objects.areEqual(this.allParameters(), other.allParameters()) && Objects.areEqual(this.returnType(), other.returnType());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("returnType", this.returnType()).add("parameters", this.allParameters()).add("loggerMethod", this.loggerMethod()).toString();
        }

        @Override
        public ExecutableElement reference() {
            return this.method;
        }

        @Override
        public int compareTo(MessageMethod o) {
            int result = this.name().compareTo(o.name());
            result = result != 0 ? result : this.returnType.name().compareTo(o.returnType().name());
            int n = result = result != 0 ? result : this.allParameters.size() - o.allParameters().size();
            if (result == 0) {
                Iterator<Parameter> params1 = this.allParameters.iterator();
                Iterator<Parameter> params2 = o.allParameters().iterator();
                while (params1.hasNext()) {
                    if (params2.hasNext()) {
                        Parameter param1 = params1.next();
                        Parameter param2 = params2.next();
                        result = param1.compareTo(param2);
                    } else {
                        result = 1;
                    }
                    if (result == 0) continue;
                    break;
                }
            }
            return result;
        }
    }
}

