/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import java.util.Collections;
import java.util.DuplicateFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import org.jboss.logging.generator.validation.AbstractFormatPart;

class StringFormatPart
extends AbstractFormatPart {
    private int index;
    private final Set<Flag> flags = new LinkedHashSet<Flag>();
    private int width;
    private int precision;
    private Conversion conversion;
    private Character dateTimeConversion;
    private final int position;

    private StringFormatPart(int position) {
        this.position = position;
    }

    public static StringFormatPart of(int position, String[] group) throws IllegalArgumentException {
        if (group.length != 6) {
            throw new IllegalArgumentException("Groups must have a length of 6.");
        }
        StringFormatPart result = new StringFormatPart(position);
        int charIndex = 0;
        result.initIndex(group[charIndex++]);
        result.initFlags(group[charIndex++]);
        result.initWidth(group[charIndex++]);
        result.initPrecision(group[charIndex++]);
        if (group[charIndex] != null && group[charIndex].equalsIgnoreCase(Conversion.DATE_TIME.asString())) {
            result.conversion = Conversion.DATE_TIME;
            result.dateTimeConversion = Character.valueOf(group[++charIndex].charAt(0));
        } else {
            result.conversion = Conversion.fromChar(group[++charIndex].charAt(0));
            result.dateTimeConversion = null;
        }
        return result;
    }

    @Override
    public int index() {
        return this.index;
    }

    public Set<Flag> flags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public int width() {
        return this.width;
    }

    public int precision() {
        return this.precision;
    }

    public Conversion conversion() {
        return this.conversion;
    }

    public char dateTimeChar() {
        return this.dateTimeConversion.charValue();
    }

    private void initIndex(String s) throws IllegalArgumentException {
        if (s == null) {
            this.index = 0;
        } else {
            try {
                this.index = Integer.parseInt(s.substring(0, s.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid index argument.", e);
            }
        }
    }

    private void initFlags(String s) throws DuplicateFormatFlagsException {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            Flag flag = Flag.parse(c);
            if (this.flags.contains((Object)flag)) {
                throw new DuplicateFormatFlagsException(String.format("Duplicate %s flag found. Current flags: %s", new Object[]{flag, this.flags}));
            }
            this.flags.add(flag);
        }
        if (this.flags.contains((Object)Flag.PREVIOUS)) {
            this.index = -1;
        }
    }

    private void initWidth(String s) throws IllegalArgumentException {
        if (s == null) {
            this.width = -1;
        } else {
            try {
                this.width = Integer.parseInt(s);
                if (this.width < 0) {
                    throw new IllegalFormatWidthException(this.width);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid width argument.", e);
            }
        }
    }

    private void initPrecision(String s) throws IllegalArgumentException {
        if (s == null) {
            this.precision = -1;
        } else {
            try {
                this.precision = Integer.parseInt(s.substring(1));
                if (this.precision < 0) {
                    throw new IllegalFormatPrecisionException(this.precision);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid precision argument.", e);
            }
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String part() {
        StringBuilder result = new StringBuilder("%");
        if (this.index > 0) {
            result.append(this.index).append("$");
        }
        if (!this.flags.isEmpty()) {
            for (Flag flag : this.flags) {
                result.append(flag.flag);
            }
        }
        if (this.width > 0) {
            result.append(this.width);
        }
        if (this.precision > 0) {
            result.append(".").append(this.precision);
        }
        result.append(this.conversion.asChar());
        if (this.conversion.isDateTime() && this.dateTimeConversion != null) {
            result.append(this.dateTimeConversion);
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + "index=" + this.index + ", flags=" + this.flags + ", width=" + this.width + ", precision=" + this.precision + ", conversion=" + (Object)((Object)this.conversion) + "]";
    }

    public static enum Conversion {
        BOOLEAN('b', true){

            @Override
            public boolean isGeneral() {
                return true;
            }
        }
        ,
        HEX('h', true){

            @Override
            public boolean isGeneral() {
                return true;
            }
        }
        ,
        STRING('s', true){

            @Override
            public boolean isGeneral() {
                return true;
            }
        }
        ,
        UNICODE_CHAR('c', true){

            @Override
            public boolean isCharacter() {
                return true;
            }
        }
        ,
        DECIMAL_INTEGER('d', false){

            @Override
            public boolean isIntegral() {
                return true;
            }
        }
        ,
        OCTAL_INTEGER('o', false){

            @Override
            public boolean isIntegral() {
                return true;
            }
        }
        ,
        HEX_INTEGER('x', true){

            @Override
            public boolean isIntegral() {
                return true;
            }
        }
        ,
        SCIENTIFIC_NOTATION('e', true){

            @Override
            public boolean isFloatingPoint() {
                return true;
            }
        }
        ,
        DECIMAL('f', false){

            @Override
            public boolean isFloatingPoint() {
                return true;
            }
        }
        ,
        SCIENTIFIC_NOTATION_OR_DECIMAL('g', true){

            @Override
            public boolean isFloatingPoint() {
                return true;
            }
        }
        ,
        HEX_FLOATING_POINT('a', true){

            @Override
            public boolean isFloatingPoint() {
                return true;
            }
        }
        ,
        DATE_TIME('t', true){

            @Override
            public boolean isDateTime() {
                return true;
            }
        }
        ,
        PERCENT('%', false){

            @Override
            public boolean isPercent() {
                return true;
            }
        }
        ,
        LINE_SEPARATOR('n', false){

            @Override
            public boolean isLineSeparator() {
                return true;
            }
        };

        private final char conversion;
        final boolean ignoreCase;

        private Conversion(char conversion, boolean ignoreCase) {
            this.conversion = conversion;
            this.ignoreCase = ignoreCase;
        }

        public boolean isGeneral() {
            return false;
        }

        public boolean isCharacter() {
            return false;
        }

        public boolean isIntegral() {
            return false;
        }

        public boolean isFloatingPoint() {
            return false;
        }

        public boolean isDateTime() {
            return false;
        }

        public boolean isPercent() {
            return false;
        }

        public boolean isLineSeparator() {
            return false;
        }

        public char asChar() {
            return this.conversion;
        }

        public String asString() {
            return String.valueOf(this.conversion);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.name());
            result.append("(");
            result.append(this.conversion);
            if (this.ignoreCase) {
                result.append(", ").append(Character.toUpperCase(this.conversion));
            }
            result.append(")");
            return result.toString();
        }

        public static Conversion fromChar(char c) throws UnknownFormatConversionException {
            for (Conversion conversion : Conversion.values()) {
                if (conversion.ignoreCase && conversion.asChar() == Character.toLowerCase(c)) {
                    return conversion;
                }
                if (conversion.asChar() != c) continue;
                return conversion;
            }
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
    }

    public static enum Flag {
        LEFT_JUSTIFY('-'),
        CONVERSION_DEPENDENT_ALTERNATE('#'),
        INCLUDE_SIGN('+'),
        SPACE_FOR_POSITIVE_VALUES(' '),
        ZERO_PADDED('0'),
        LOCALE_GROUPING_SEPARATOR(','),
        PARENTHESES_FOR_NEGATIVES('('),
        PREVIOUS('<');

        final char flag;

        private Flag(char flag) {
            this.flag = flag;
        }

        public String toString() {
            return this.name() + "(" + this.flag + ")";
        }

        public static Flag parse(char c) throws UnknownFormatFlagsException {
            for (Flag flag : Flag.values()) {
                if (flag.flag != c) continue;
                return flag;
            }
            throw new UnknownFormatFlagsException("Invalid flag: " + c);
        }
    }
}

