/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.validation.FormatValidator;
import org.jboss.logging.generator.validation.FormatValidatorFactory;
import org.jboss.logging.generator.validation.MessageIdValidator;
import org.jboss.logging.generator.validation.ValidationMessage;
import org.jboss.logging.generator.validation.ValidationMessageFactory;

public final class Validator {
    public static final Validator INSTANCE = new Validator();

    private Validator() {
    }

    public final Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (messageInterface.isMessageBundle()) {
            String projectCode = messageInterface.projectCode();
            Set<Method> methods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(projectCode, methods));
            messages.addAll(this.validateBundle(methods));
        } else if (messageInterface.isMessageLogger()) {
            String projectCode = messageInterface.projectCode();
            Set<Method> methods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(projectCode, methods));
            messages.addAll(this.validateLogger(methods));
        } else {
            messages.add(ValidationMessageFactory.createError(messageInterface, "Message interface %s is not a message bundle or message logger.", messageInterface.name()));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateCommon(String projectCode, Set<Method> methods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, Method> methodNames = new HashMap<String, Method>();
        for (Method method : methods) {
            FormatValidator formatValidator;
            Method.Message message = method.message();
            if (message == null) {
                messages.add(ValidationMessageFactory.createError(method, "All message bundles and message logger methods must have or inherit a message."));
                continue;
            }
            if (message.hasId()) {
                if (message.id() < 0) {
                    messages.add(ValidationMessageFactory.createError(method, "Message id %d is invalid. Must be greater than 0 or inherit another valid id.", message.id()));
                } else {
                    messages.addAll(MessageIdValidator.INSTANCE.validate(projectCode, method));
                }
            }
            if ((formatValidator = FormatValidatorFactory.create(method)).isValid()) {
                int paramCount = method.formatParameterCount();
                if (method.formatParameterCount() != formatValidator.argumentCount()) {
                    messages.add(ValidationMessageFactory.createError(method, "Parameter count does not match for format '%s'. Required: %d Provided: %d", formatValidator.format(), formatValidator.argumentCount(), paramCount));
                }
            } else {
                messages.add(ValidationMessageFactory.createError(method, formatValidator.summaryMessage()));
            }
            if (!method.inheritsMessage()) {
                String key = method.name() + method.formatParameterCount();
                if (methodNames.containsKey(key)) {
                    Method previousMethod = (Method)methodNames.get(key);
                    messages.add(ValidationMessageFactory.createError(previousMethod, "Only one message with the same format parameters is allowed."));
                    messages.add(ValidationMessageFactory.createError(method, "Only one message with the same format parameters is allowed."));
                } else {
                    methodNames.put(key, method);
                }
            }
            messages.addAll(this.validateParameters(method));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateParameters(Method method) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean foundCause = false;
        for (Parameter parameter : method.allParameters()) {
            if (!parameter.isCause()) continue;
            if (foundCause) {
                messages.add(ValidationMessageFactory.createError(method, "Only one cause parameter is allowed."));
                break;
            }
            foundCause = true;
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundle(Set<Method> methods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Method method : methods) {
            messages.addAll(this.validateBundleMethod(method));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundleMethod(Method method) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ReturnType returnType = method.returnType();
        if (returnType.equals(ReturnType.VOID) || returnType.isPrimitive()) {
            messages.add(ValidationMessageFactory.createError(method, "Message bundle method %s has an invalid return type. Cannot be void or a primitive.", method.name()));
        } else if (returnType.isThrowable()) {
            ReturnType.ThrowableReturnType throwableReturnType;
            if (!returnType.isSubtypeOf(Throwable.class)) {
                messages.add(ValidationMessageFactory.createError(method, "Message bundle method %s has an invalid return type of %s.", method.name(), returnType.name()));
            }
            if (!(throwableReturnType = returnType.throwableReturnType()).useConstructionParameters()) {
                if (!throwableReturnType.useConstructionParameters() && !method.constructorParameters().isEmpty()) {
                    messages.add(ValidationMessageFactory.createError(method, "Method does not have an usable constructor for the return type %s.", returnType.name()));
                } else {
                    boolean usableConstructor;
                    boolean hasMessageConstructor = throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasStringConstructor();
                    boolean bl = usableConstructor = throwableReturnType.hasDefaultConstructor() || throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasStringConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasThrowableConstructor();
                    if (!usableConstructor) {
                        messages.add(ValidationMessageFactory.createError(method, "Method does not have an usable constructor for the return type %s.", returnType.name()));
                    } else if (!hasMessageConstructor) {
                        messages.add(ValidationMessageFactory.createWarning(method, "The message cannot be set via the throwable constructor and will be ignored."));
                    }
                }
            }
        } else if (!returnType.isAssignableFrom(String.class)) {
            messages.add(ValidationMessageFactory.createError(method, "Return type %s does not appear valid for a message bundle.", method.name()));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLogger(Set<Method> methods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Method method : methods) {
            if (method.isLoggerMethod()) {
                messages.addAll(this.validateLoggerMethod(method));
                continue;
            }
            messages.addAll(this.validateBundleMethod(method));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLoggerMethod(Method method) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!ReturnType.VOID.equals(method.returnType())) {
            messages.add(ValidationMessageFactory.createError(method, "Message logger methods can only have a void return type."));
        }
        return messages;
    }

    private Set<Method> getAllMethods(MessageInterface messageInterface) {
        if (messageInterface.isBasicLogger()) {
            return Collections.emptySet();
        }
        HashSet<Method> methods = new HashSet<Method>();
        for (Method method : messageInterface.methods()) {
            methods.add(method);
        }
        for (MessageInterface msgInterface : messageInterface.extendedInterfaces()) {
            methods.addAll(this.getAllMethods(msgInterface));
        }
        return methods;
    }
}

