/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.util.HashSet;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.model.ClassModelHelper;
import org.jboss.logging.generator.model.ImplementationClassModel;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";
    private JFieldVar log;

    public MessageLoggerImplementor(MessageInterface messageInterface) {
        super(messageInterface);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.log = this.getDefinedClass().field(10, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JFieldVar projectCodeVar = null;
        if (!this.messageInterface().projectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.messageInterface().projectCode()));
        }
        JFieldVar fqcn = this.getDefinedClass().field(28, String.class, FQCN_FIELD_NAME);
        fqcn.init((JExpression)this.getDefinedClass().dotclass().invoke("getName"));
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)this.log), (JExpression)constructorParam);
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.isBasicLogger()) {
                this.implementBasicLogger(codeModel, messageInterface);
                continue;
            }
            methods.addAll(messageInterface.methods());
        }
        for (Method method : methods) {
            JClass returnType = codeModel.ref(method.returnType().name());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, method.name());
            jMethod.annotate(Override.class);
            JMethod msgMethod = this.addMessageMethod(method);
            if (method.isLoggerMethod()) {
                this.createLoggerMethod(method, jMethod, msgMethod, (JVar)projectCodeVar);
                continue;
            }
            this.createBundleMethod(method, jMethod, msgMethod, (JVar)projectCodeVar);
        }
        return codeModel;
    }

    private void createLoggerMethod(Method messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        JBlock body = method.body();
        StringBuilder logMethod = new StringBuilder(messageMethod.loggerMethod());
        JInvocation logInv = body.invoke((JExpression)this.log, logMethod.toString());
        logInv.arg((JExpression)JExpr.ref((String)FQCN_FIELD_NAME));
        logInv.arg(JExpr.direct((String)messageMethod.logLevelParameter()));
        if (messageMethod.hasCause()) {
            logInv.arg(JExpr.direct((String)messageMethod.cause().name()));
        } else {
            logInv.arg(JExpr._null());
        }
        Method.Message message = messageMethod.message();
        if (message.hasId() && projectCodeVar != null) {
            String formattedId = ClassModelHelper.formatMessageId(message.id());
            logInv.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (Parameter param : messageMethod.allParameters()) {
            JClass paramType = this.getCodeModel().ref(param.type());
            JVar var = method.param(8, (JType)paramType, param.name());
            if (param.isCause() || param.isParam()) continue;
            logInv.arg((JExpression)var);
        }
    }

    private void implementBasicLogger(JCodeModel codeModel, MessageInterface messageInterface) {
        for (Method method : messageInterface.methods()) {
            Object returnType = method.returnType().equals(ReturnType.VOID) ? codeModel.VOID : (method.returnType().isPrimitive() ? JClass.parse((JCodeModel)codeModel, (String)method.returnType().name()) : codeModel.ref(method.returnType().name()));
            JMethod blMethod = this.getDefinedClass().method(9, (JType)returnType, method.name());
            blMethod.annotate(Override.class);
            JBlock body = blMethod.body();
            JInvocation logInv = JExpr.invoke((JExpression)this.log, (String)method.name());
            for (Parameter parameter : method.allParameters()) {
                JClass param = codeModel.ref(parameter.type());
                JVar methodParam = parameter.isVarArgs() ? blMethod.varParam((JType)param, parameter.name()) : (parameter.isArray() ? blMethod.param(8, (JType)param.array(), parameter.name()) : blMethod.param(8, (JType)param, parameter.name()));
                logInv.arg((JExpression)methodParam);
            }
            if (ReturnType.VOID.equals(method.returnType())) {
                body.add((JStatement)logInv);
                continue;
            }
            body._return((JExpression)logInv);
        }
    }
}

