/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JMethod;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.model.ClassModel;

class MessageBundleTranslator
extends ClassModel {
    private final Map<Method, String> translations;

    public MessageBundleTranslator(MessageInterface messageInterface, String className, String superClassName, Map<Method, String> translations) {
        super(messageInterface, className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JCodeModel generateModel() throws IllegalStateException {
        JCodeModel model = super.generateModel();
        JDefinedClass definedClass = this.getDefinedClass();
        JMethod constructor = definedClass.constructor(2);
        constructor.body().invoke("super");
        JMethod readResolve = this.createReadResolveMethod();
        readResolve.annotate(Override.class);
        Set<Map.Entry<Method, String>> entries = this.translations.entrySet();
        HashSet<String> methodNames = new HashSet<String>();
        for (Map.Entry<Method, String> entry : entries) {
            JMethod method = this.addMessageMethod(entry.getKey(), entry.getValue());
            if (!methodNames.add(method.name())) continue;
            method.annotate(Override.class);
        }
        return model;
    }
}

