/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.model.ClassModel;
import org.jboss.logging.generator.model.ClassModelHelper;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(MessageInterface messageInterface) {
        super(messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.getDefinedClass()._implements(codeModel.ref(Serializable.class));
        JFieldVar serialVersionUID = this.getDefinedClass().field(28, (JType)codeModel.LONG, "serialVersionUID");
        serialVersionUID.init(JExpr.lit((long)1L));
        return codeModel;
    }

    void createBundleMethod(Method messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().ref(method.type().fullName());
        JVar result = body.decl((JType)returnField, "result");
        Method.Message message = messageMethod.message();
        JClass formatter = this.getCodeModel().ref(message.format().formatClass());
        JInvocation formatterMethod = formatter.staticInvoke(message.format().staticMethod());
        if (messageMethod.allParameters().isEmpty()) {
            if (messageMethod.returnType().isThrowable()) {
                if (message.hasId() && projectCodeVar != null) {
                    String formattedId = ClassModelHelper.formatMessageId(message.id());
                    formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
                    this.initCause(result, returnField, body, messageMethod, formatterMethod);
                } else {
                    this.initCause(result, returnField, body, messageMethod, JExpr.invoke((JMethod)msgMethod));
                }
            } else {
                result.init((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
        } else {
            if (message.hasId() && projectCodeVar != null) {
                String formattedId = ClassModelHelper.formatMessageId(message.id());
                formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            } else {
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
            for (Parameter param : messageMethod.allParameters()) {
                JClass paramType = this.getCodeModel().ref(param.type());
                method.param(8, (JType)paramType, param.name());
            }
            for (Parameter param : messageMethod.formatParameters()) {
                String formatterClass = param.getFormatterClass();
                if (formatterClass == null) {
                    formatterMethod.arg(JExpr.direct((String)param.name()));
                    continue;
                }
                formatterMethod.arg((JExpression)JExpr._new((JType)JClass.parse((JCodeModel)this.getCodeModel(), (String)formatterClass)).arg(JExpr.direct((String)param.name())));
            }
            if (messageMethod.returnType().isThrowable()) {
                this.initCause(result, returnField, body, messageMethod, formatterMethod);
            } else {
                result.init((JExpression)formatterMethod);
            }
        }
        body._return((JExpression)result);
    }

    private void initCause(JVar result, JClass returnField, JBlock body, Method method, JInvocation formatterMethod) {
        JInvocation initCause;
        ReturnType.ThrowableReturnType returnType = method.returnType().throwableReturnType();
        if (returnType.useConstructionParameters()) {
            JInvocation invocation = JExpr._new((JClass)returnField);
            for (Parameter param : returnType.constructionParameters()) {
                if (param.isMessage()) {
                    invocation.arg((JExpression)formatterMethod);
                    continue;
                }
                invocation.arg((JExpression)JExpr.ref((String)param.name()));
            }
            result.init((JExpression)invocation);
        } else if (returnType.hasStringAndThrowableConstructor() && method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod).arg((JExpression)JExpr.ref((String)method.cause().name())));
        } else if (returnType.hasThrowableAndStringConstructor() && method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)method.cause().name())).arg((JExpression)formatterMethod));
        } else if (returnType.hasStringConstructor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod));
            if (method.hasCause()) {
                initCause = body.invoke((JExpression)result, "initCause");
                initCause.arg((JExpression)JExpr.ref((String)method.cause().name()));
            }
        } else if (returnType.hasThrowableConstructor() && method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)method.cause().name())));
        } else if (returnType.hasStringAndThrowableConstructor() && !method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod).arg(JExpr._null()));
        } else if (returnType.hasThrowableAndStringConstructor() && !method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(JExpr._null()).arg((JExpression)formatterMethod));
        } else if (method.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            initCause = body.invoke((JExpression)result, "initCause");
            initCause.arg((JExpression)JExpr.ref((String)method.cause().name()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
        JClass arrays = this.getCodeModel().ref(Arrays.class);
        JClass stClass = this.getCodeModel().ref(StackTraceElement.class).array();
        JVar st = body.decl((JType)stClass, "st").init((JExpression)result.invoke("getStackTrace"));
        JInvocation setStackTrace = result.invoke("setStackTrace");
        setStackTrace.arg((JExpression)arrays.staticInvoke("copyOfRange").arg((JExpression)st).arg(JExpr.lit((int)1)).arg((JExpression)st.ref("length")));
        body.add((JStatement)setStackTrace);
    }
}

