/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.intf.model;

import java.util.Set;
import org.jboss.logging.generator.intf.model.MessageObject;
import org.jboss.logging.generator.intf.model.MessageObjectType;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.util.Objects;

public interface ReturnType
extends MessageObject,
MessageObjectType {
    public static final ReturnType VOID = new VoidReturnType();

    public boolean isThrowable();

    public boolean isPrimitive();

    @Override
    public String name();

    public ThrowableReturnType throwableReturnType();

    public static interface ThrowableReturnType
    extends MessageObject,
    MessageObjectType {
        public boolean hasDefaultConstructor();

        public boolean hasStringAndThrowableConstructor();

        public boolean hasStringConstructor();

        public boolean hasThrowableAndStringConstructor();

        public boolean hasThrowableConstructor();

        public boolean useConstructionParameters();

        public Set<Parameter> constructionParameters();

        @Override
        public String name();
    }

    public static final class VoidReturnType
    implements ReturnType {
        private VoidReturnType() {
        }

        @Override
        public boolean isThrowable() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public String name() {
            return "void";
        }

        @Override
        public ThrowableReturnType throwableReturnType() {
            return null;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VoidReturnType)) {
                return false;
            }
            VoidReturnType other = (VoidReturnType)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add(this.name()).toString();
        }

        @Override
        public Class<Void> reference() {
            return Void.TYPE;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return type.equals(Void.TYPE);
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            return false;
        }
    }
}

